% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%ne\%}
\alias{\%ne\%}
\title{Check for inequality of two objects}
\usage{
x1 \%ne\% x2
}
\arguments{
\item{x1}{The first object to compare}

\item{x2}{The second object to compare}
}
\value{
A single TRUE or FALSE value depending on whether the objects are
not equal.
}
\description{
The goal of the \code{\%ne\%} operator is to return a TRUE
or FALSE value when any two objects are compared.  The function is the
opposite of the equality operator. It returns a TRUE when the objects
are not equal.

This operator also allows comparing
of data frames.  It will return TRUE if any values in the
data frames are not equal, and ignores differences in attributes.
}
\examples{
# Comparing of NULLs and NA
NULL \%ne\% NULL        # FALSE
NULL \%ne\% NA          # TRUE
NA \%ne\% NA            # FALSE
1 \%ne\% NULL           # TRUE
1 \%ne\% NA             # TRUE

# Comparing of atomic values
1 \%ne\% 1              # FALSE
"one" \%ne\% "one"      # FALSE
1 \%ne\% "one"          # TRUE
1 \%ne\% Sys.Date()     # TRUE

# Comparing of vectors
v1 <- c("A", "B", "C")
v2 <- c("A", "B", "D")
v1 \%ne\% v1            # FALSE
v1 \%ne\% v2            # TRUE

# Comparing of data frames
mtcars \%ne\% mtcars    # FALSE
mtcars \%ne\% iris      # TRUE
iris \%ne\% iris[1:50,] # TRUE

# Mixing it up
mtcars \%ne\% NULL      # TRUE
v1 \%ne\% NA            # TRUE
1 \%ne\% v1             # TRUE
}
\seealso{
Other operators: 
\code{\link{\%eq\%}()},
\code{\link{\%ge\%}()},
\code{\link{\%gt\%}()},
\code{\link{\%le\%}()},
\code{\link{\%lt\%}()},
\code{\link{\%p\%}()}
}
\concept{operators}
