% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makefile.R
\name{makefile}
\alias{makefile}
\title{Create a Makefile}
\usage{
makefile(
  path_files = NULL,
  dir_make = NULL,
  name_make = "Makefile",
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{path_files}{A path from \code{dir_make} to a
directory with R scripts containing
calls to \code{\link[=cmd_assign]{cmd_assign()}}.
Optional.}

\item{dir_make}{The directory where
\code{makefile()} will create the Makefile.
If no value is supplied, then `makefile();
creates the Makefile the current working directory.}

\item{name_make}{The name of the Makefile.
The default is \code{"Makefile"}.}

\item{overwrite}{Whether to overwrite
an existing Makefile. Default is \code{FALSE}.}

\item{quiet}{Whether to suppress
progress messages. Default is \code{FALSE}.}
}
\value{
\code{makefile()} is called for its
side effect, which is to create a
file. However, \code{makefile()} also
returns a string with the contents of the
Makefile.
}
\description{
Create a Makefile for a data analysis workflow.
The Makefile can include
rules extracted from existing R files.
}
\details{
To create a Makefile in the \code{files}
directory, set \code{files} to \code{"."}.

To obtain the contents of the Makefile
without creating a file on disk,
creating the file on disk, set
\code{name_make} to \code{NULL}.

Supplying a value for \code{files} is
optional for \code{makefile()},
but compulsory for \code{\link[=shell_script]{shell_script()}}.
The output from \code{makefile()}
includes some general-purpose Makefile
commands, while the output from
\code{\link[=shell_script]{shell_script()}} is generated entirely
from \code{files}.
}
\examples{
library(fs)
library(withr)

with_tempdir({

  ## create 'src'  directory
  dir_create("src")

  ## put R scripts containing calls to
  ## 'cmd_assign' in the 'src' directory
  writeLines(c("cmd_assign(x = 1, .out = 'out/results.rds')",
               "results <- x + 1",
               "saveRDS(results, file = .out)"),
             con = "src/results.R")
  writeLines(c("cmd_assign(x = 1, .out = 'out/more_results.rds')",
               "more_results <- x + 2",
               "saveRDS(more_results, file = .out)"),
             con = "src/more_results.R")

  ## call 'makefile()'
  makefile(path_files = "src",
           dir_make = ".")

  ## Makefile has been created
  dir_tree()

  ## print contents of Makefile
  cat(readLines("Makefile"), sep = "\n")

})
}
\references{
\itemize{
\item \href{https://jeroenjanssens.com/dsatcl/chapter-6-project-management-with-make}{Project Management with Make}
Makefiles in data analysis workflows
\item \href{https://www.gnu.org/software/make/manual/make.html#SEC_Contents}{GNU make}
Definitive guide
\item \href{https://swcarpentry.github.io/r-novice-inflammation/05-cmdline.html}{Command-Line Programs}
Introduction to Rscript
}
}
\seealso{
\itemize{
\item \href{https://bayesiandemography.github.io/command/articles/a3_makefile.html}{Creating a Makefile}
More on \code{makefile()}
\item \code{\link[=extract_make]{extract_make()}} Turn a \code{\link[=cmd_assign]{cmd_assign()}} call into a Makefile rule
\item \code{\link[=shell_script]{shell_script()}} Shell script equivalent of \code{makefile()}
\item \code{\link[=cmd_assign]{cmd_assign()}} Process command line arguments
\item \href{https://bayesiandemography.github.io/command/articles/workflow.html}{Modular Workflows for Data Analysis}
Safe, flexible data analysis workflows
\item \href{https://CRAN.R-project.org/package=littler}{littler} Alternative to Rscript
}
}
