% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_data.R
\name{get_color_data}
\alias{get_color_data}
\title{Get Color Database}
\usage{
get_color_data()
}
\value{
A data frame with the following columns:
\describe{
\item{name}{Character vector of color names (lowercase)}
\item{hex}{Character vector of hexadecimal color codes (uppercase, format: #RRGGBB)}
\item{lab_l, lab_a, lab_b}{(Optional) LAB color space coordinates, added when
the \code{farver} package is available}
}

The data frame contains over 32,000 rows representing all available colors,
including both R's 657 built-in colors and the extended color-names database.
}
\description{
Returns the complete color database as a data frame containing all 32,000+
color names and their corresponding hexadecimal codes.
}
\details{
The returned data frame is sorted alphabetically by color name. Each color
name maps to exactly one hex code, though multiple color names may share
the same hex code.

This function is useful for:
\itemize{
\item Exploring available color names
\item Creating custom color palettes
\item Searching for colors by name pattern
\item Analyzing color distributions
\item Building color visualization tools
}
}
\examples{
# Get the complete color database
colors_df <- get_color_data()
head(colors_df)

# See dimensions
dim(colors_df)

# Find all colors containing "blue"
blue_colors <- colors_df[grepl("blue", colors_df$name), ]
head(blue_colors)

# Get a random sample of colors
set.seed(123)
sample_colors <- colors_df[sample(nrow(colors_df), 10), ]
sample_colors
}
\seealso{
\code{\link{color_to_hex}} for converting specific color names to hex codes,
\code{\link{hex_to_color}} for the reverse conversion,
\code{\link{create_color_table}} for creating visual color tables
}
