% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.missing.R
\name{is.missing}
\alias{is.missing}
\title{Find out which elements of a vector have missing values}
\usage{
is.missing(x, codelist = attr(x, "codelist"))
}
\arguments{
\item{x}{vector for which the missing elements have to be detected.}

\item{codelist}{a \code{\link{codelist}} object or a \code{data.frame} that
is a valid code list.}
}
\value{
Returns a logical vector of the same length as \code{x} with \code{TRUE}
indicating corresponing values in \code{x} that can be considered to be
missing.
}
\description{
Find out which elements of a vector have missing values
}
\details{
Unlike \code{\link{is.na}} \code{is.missing} will also return \code{TRUE} for
elements of \code{x} whose values are indicated in the code list to be
missing values. For that to work \code{codelist} needs to be a valid
\code{\link{codelist}} with a 'missing' column. This column needs to be
interpretable as a logical vector. When \code{codelist} is missing or does
not contain a 'missing' column the result of \code{is.missing} is the same as
\code{\link{is.na}}.
}
