% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_labels.R
\name{in_labels}
\alias{in_labels}
\title{Match codes based on label}
\usage{
in_labels(
  x,
  labels,
  codelist = attr(x, "codelist"),
  locale = cl_locale(codelist)
)
}
\arguments{
\item{x}{vector with codes. Should be of the same type as the codes in the
codelist.}

\item{labels}{vector with labels.}

\item{codelist}{a \code{\link{codelist}} object or a \code{data.frame} that
is a valid code list or and object that has a 'codelist' attribute
containing a codelist.}

\item{locale}{use the codes from the given locale. Should be character vector 
of length 1.}
}
\value{
A logical vector of the same length as \code{x} indicating for each value if
the code has a label present in \code{labels}.
}
\description{
Match codes based on label
}
\examples{
data(objectcodes)
data(objectsales)
objectsales$product <- code(objectsales$product, objectcodes)

in_labels(objectsales$product, c("Electric Drill", "Toys"))

subset(objectsales, in_labels(product, c("Electric Drill", "Hammer")))

}
