% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codes.R
\name{codes}
\alias{codes}
\alias{codes.default}
\alias{codes.code}
\alias{to_codes}
\title{Get the codes belonging to given labels}
\usage{
codes(x, ...)

\method{codes}{default}(x, codelist, locale = cl_locale(codelist), ...)

\method{codes}{code}(x, ...)

to_codes(x, codelist, locale = cl_locale(codelist))
}
\arguments{
\item{x}{character vector with labels.}

\item{...}{used to pass arguments to other methods.}

\item{codelist}{a \code{\link{codelist}} object or a \code{data.frame} that
is a valid code list or and object that has a 'codelist' attribute
containing a codelist.}

\item{locale}{use the codes from the given locale. Should be a character vector 
of length 1.}
}
\value{
Returns a vector of codes. Will give an error when one of the labels cannot
be found in the codelist for the given locale. When \code{x} is an object of
type 'code' the codes themselves are returned stripped from the 'code'
class and with the 'codelist' attribute removed.
}
\description{
Get the codes belonging to given labels
}
\details{
\code{to_codes} has the same functionality as a call to \code{codes.default}.
}
\examples{
data(objectcodes)
data(objectsales)
objectsales$product <- code(objectsales$product, objectcodes)

codes(c("Hammer", "Electric Drill"), objectcodes)
codes(c("Hammer", "Electric Drill"), cl(objectsales$product))

}
\seealso{
See \code{\link{as.label}} for an alternative in comparisons.
}
