% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-day.R
\name{year-month-day-setters}
\alias{year-month-day-setters}
\alias{set_year.clock_year_month_day}
\alias{set_month.clock_year_month_day}
\alias{set_day.clock_year_month_day}
\alias{set_hour.clock_year_month_day}
\alias{set_minute.clock_year_month_day}
\alias{set_second.clock_year_month_day}
\alias{set_millisecond.clock_year_month_day}
\alias{set_microsecond.clock_year_month_day}
\alias{set_nanosecond.clock_year_month_day}
\title{Setters: year-month-day}
\usage{
\method{set_year}{clock_year_month_day}(x, value, ...)

\method{set_month}{clock_year_month_day}(x, value, ...)

\method{set_day}{clock_year_month_day}(x, value, ...)

\method{set_hour}{clock_year_month_day}(x, value, ...)

\method{set_minute}{clock_year_month_day}(x, value, ...)

\method{set_second}{clock_year_month_day}(x, value, ...)

\method{set_millisecond}{clock_year_month_day}(x, value, ...)

\method{set_microsecond}{clock_year_month_day}(x, value, ...)

\method{set_nanosecond}{clock_year_month_day}(x, value, ...)
}
\arguments{
\item{x}{\verb{[clock_year_month_day]}

A year-month-day vector.}

\item{value}{\verb{[integer / "last"]}

The value to set the component to.

For \code{set_day()}, this can also be \code{"last"} to set the day to the
last day of the month.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} with the component set.
}
\description{
These are year-month-day methods for the
\link[=clock-setters]{setter generics}.
\itemize{
\item \code{set_year()} sets the Gregorian year.
\item \code{set_month()} sets the month of the year. Valid values are in the range
of \verb{[1, 12]}.
\item \code{set_day()} sets the day of the month. Valid values are in the range
of \verb{[1, 31]}.
\item There are sub-daily setters for setting more precise components.
}
}
\examples{
x <- year_month_day(2019, 1:3)

# Set the day
set_day(x, 12:14)

# Set to the "last" day of the month
set_day(x, "last")

# Set to an invalid day of the month
invalid <- set_day(x, 31)
invalid

# Then resolve the invalid day by choosing the next valid day
invalid_resolve(invalid, invalid = "next")

# Cannot set a component two levels more precise than where you currently are
try(set_hour(x, 5))
}
