% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_recruiting.R
\name{cfbd_recruiting}
\alias{cfbd_recruiting}
\alias{recruiting}
\title{\strong{CFB Recruiting Endpoint Overview}}
\description{
\describe{
\item{\code{cfbd_recruiting_player()}:}{ Get college football player recruiting information for a single year with filters available for team, recruit type, state and position.}

\item{\code{cfbd_recruiting_position()}:}{ Get college football position group recruiting information .}

\item{\code{cfbd_recruiting_team()}:}{ Get college football recruiting team rankings information.}
}
\subsection{\strong{Get player recruiting rankings}}{

Get college football player recruiting information for a single year with filters available
for team, recruit type, state and position.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_recruiting_player(2018, team = "Texas")

cfbd_recruiting_player(2016, recruit_type = "JUCO")

cfbd_recruiting_player(2020, recruit_type = "HighSchool", position = "OT", state = "FL")
}\if{html}{\out{</div>}}
}

\subsection{\strong{Get college football position group recruiting information.}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_recruiting_position(2018, team = "Texas")

cfbd_recruiting_position(2016, 2020, team = "Virginia")

cfbd_recruiting_position(2015, 2020, conference = "SEC")
}\if{html}{\out{</div>}}
}

\subsection{\strong{Get college football recruiting team rankings information.}}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfbd_recruiting_team(2018, team = "Texas")

cfbd_recruiting_team(2016, team = "Virginia")

cfbd_recruiting_team(2016, team = "Texas A&M")

cfbd_recruiting_team(2011)
}\if{html}{\out{</div>}}
}
}
\details{
Gets CFB team recruiting ranks with filters available for year and team.
At least one of \strong{year} or \strong{team} must be specified for the function to run

If you would like CFB recruiting information for players, please
see the \code{\link[=cfbd_recruiting_player]{cfbd_recruiting_player()}} function

If you would like to get CFB recruiting information based on position groups during a
time period for all FBS teams, please see the \code{\link[=cfbd_recruiting_position]{cfbd_recruiting_position()}} function.

\code{\link[=cfbd_recruiting_player]{cfbd_recruiting_player()}} - At least one of \strong{year} or \strong{team} must be specified for the function to run

\code{\link[=cfbd_recruiting_position]{cfbd_recruiting_position()}} - If only start_year is provided, function will get CFB recruiting information based
on position groups during that year for all FBS teams.
}
