% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_metrics.R
\name{cfbd_metrics_ppa_games}
\alias{cfbd_metrics_ppa_games}
\title{\strong{Get team game averages for predicted points added (PPA)}}
\usage{
cfbd_metrics_ppa_games(
  year,
  week = NULL,
  season_type = "both",
  team = NULL,
  conference = NULL,
  excl_garbage_time = FALSE
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week - values range from 1-15, 1-14 for seasons pre-playoff, i.e. 2013 or earlier}

\item{season_type}{(\emph{String} default both): Season type - regular, postseason, both, allstar, spring_regular, spring_postseason}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}

\item{excl_garbage_time}{(\emph{Logical} default FALSE): Select whether to exclude Garbage Time (TRUE or FALSE)}
}
\value{
\code{\link[=cfbd_metrics_ppa_games]{cfbd_metrics_ppa_games()}} - A data frame with 18 variables:
\describe{
\item{\code{game_id}: integer.}{Referencing game id.}
\item{\code{season}: integer.}{Season of the game.}
\item{\code{week}: integer.}{Game week of the season.}
\item{\code{season_type}: character.}{Season Type (regular, postseason, etc.}
\item{\code{conference}: character.}{Conference of the team.}
\item{\code{team}: character.}{Team name.}
\item{\code{opponent}: character.}{Team Opponent.}
\item{\code{off_overall}: character.}{Offense overall predicted points added (PPA).}
\item{\code{off_passing}: character.}{Offense passing predicted points added (PPA).}
\item{\code{off_rushing}: character.}{Offense rushing predicted points added (PPA).}
\item{\code{off_first_down}: character.}{Offense 1st down predicted points added (PPA).}
\item{\code{off_second_down}: character.}{Offense 2nd down predicted points added (PPA).}
\item{\code{off_third_down}: character.}{Offense 3rd down predicted points added (PPA).}
\item{\code{def_overall}: character.}{Defense overall predicted points added (PPA).}
\item{\code{def_passing}: character.}{Defense passing predicted points added (PPA).}
\item{\code{def_rushing}: character.}{Defense rushing predicted points added (PPA).}
\item{\code{def_first_down}: character.}{Defense 1st down predicted points added (PPA).}
\item{\code{def_second_down}: character.}{Defense 2nd down predicted points added (PPA).}
\item{\code{def_third_down}: character.}{Defense 3rd down predicted points added (PPA).}
}
}
\description{
\strong{Get team game averages for predicted points added (PPA)}
}
\examples{
\donttest{
  try(cfbd_metrics_ppa_games(year = 2019, team = "TCU"))
}
}
\seealso{
Other CFBD Metrics: 
\code{\link{cfbd_metrics_fg_ep}()},
\code{\link{cfbd_metrics_ppa_players_games}()},
\code{\link{cfbd_metrics_ppa_players_season}()},
\code{\link{cfbd_metrics_ppa_predicted}()},
\code{\link{cfbd_metrics_ppa_teams}()},
\code{\link{cfbd_metrics_wepa_players_kicking}()},
\code{\link{cfbd_metrics_wepa_players_passing}()},
\code{\link{cfbd_metrics_wepa_players_rushing}()},
\code{\link{cfbd_metrics_wepa_team_season}()},
\code{\link{cfbd_metrics_wp}()},
\code{\link{cfbd_metrics_wp_pregame}()}
}
\concept{CFBD Metrics}
\keyword{Points}
\keyword{Predicted}
\keyword{Teams}
