## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "R>"
)

library(causalQual)

options(cli.num_colors = 1)

set.seed(1986)

## -----------------------------------------------------------------------------
## Generate synthetic data.
n <- 2000
data <- generate_qualitative_data_soo(n, assignment = "observational", outcome_type = "ordered")

Y <- data$Y
D <- data$D
X <- data$X

## -----------------------------------------------------------------------------
## Estimation.
fit <- causalQual_soo(Y, D, X, outcome_type = "ordered")
summary(fit)

## -----------------------------------------------------------------------------
## Generate synthetic data.
n <- 2000
data <- generate_qualitative_data_iv(n, outcome_type = "ordered")

Y <- data$Y
D <- data$D
Z <- data$Z

## -----------------------------------------------------------------------------
## Estimation.
fit <- causalQual_iv(Y, D, Z)
summary(fit)

## -----------------------------------------------------------------------------
## Generate synthetic data.
n <- 2000
data <- generate_qualitative_data_rd(n, outcome_type = "ordered")

Y <- data$Y
running_variable <- data$running_variable
cutoff <- data$cutoff

## -----------------------------------------------------------------------------
## Estimation.
fit <- causalQual_rd(Y, running_variable, cutoff)
summary(fit)

## -----------------------------------------------------------------------------
n <- 2000
data <- generate_qualitative_data_did(n, assignment = "observational", outcome_type = "ordered")

Y_pre <- data$Y_pre
Y_post <- data$Y_post
D <- data$D

## -----------------------------------------------------------------------------
fit <- causalQual_did(Y_pre, Y_post, D)
summary(fit)

