% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_multigau}
\alias{make_multigau}
\title{Generate Multiple Gaussian Clusters}
\usage{
make_multigau(n = c(300, 200, 500), p = 4, k = 3, loc = NULL, scale = NULL)
}
\arguments{
\item{n}{A numeric vector (default: c(300, 200, 500)) representing the sample sizes.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{k}{A numeric value (default: 5) representing the number of clusters.}

\item{loc}{A numeric matrix (default: NULL) representing the locations/centroids of clusters.}

\item{scale}{A numeric vector (default: NULL) representing the scaling factors of clusters.}
}
\value{
A data containing the Gaussian clusters.
}
\description{
This function generates a dataset consisting of multiple Gaussian clusters.
}
\examples{
loc_matrix <- matrix(c(0, 0, 0, 0,
5, 9, 0, 0,
3, 4, 10, 7
), nrow = 3, byrow = TRUE)
multigau <- make_multigau(n = c(300, 200, 500),
p = 4, k = 3,
loc = loc_matrix, scale = c(0.2, 1.5, 0.5))
}
