% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.capr.boot}
\alias{print.capr.boot}
\title{Print method for \code{capr.boot} objects}
\usage{
\method{print}{capr.boot}(x, digits = max(4L, getOption("digits") - 4L), ...)
}
\arguments{
\item{x}{An object of class \code{capr.boot}, typically produced by \code{\link[=capr.boot]{capr.boot()}}.}

\item{digits}{Number of significant digits to show when printing numeric
values.}

\item{...}{Additional arguments passed on to \code{\link[=print.data.frame]{print.data.frame()}}.}
}
\value{
The input object \code{x}, invisibly.
}
\description{
Displays bootstrap coefficient estimates and their confidence intervals
component by component as compact tables.
}
\examples{
simu.data <- simu.capr(seed = 123L, n = 120L)
K <- 2L
fit <- capr(
    S = simu.data$S,
    X = simu.data$X,
    K = K
)
fit.boot <- capr.boot(
    fit = fit,
    nboot = 10L,
    max_iter = 20L,
    tol = 1e-6,
    seed = 123L
)
print(fit.boot)
}
