% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_eml.R
\name{write_eml}
\alias{write_eml}
\title{Transform a Camera Trap Data Package to EML}
\usage{
write_eml(x, directory, derived_paragraph = TRUE)
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by \code{\link[=read_camtrapdp]{read_camtrapdp()}}.}

\item{directory}{Path to local directory to write files to.}

\item{derived_paragraph}{If \code{TRUE}, a paragraph will be added to the
abstract, indicating that data have been transformed using \code{write_dwc()}.}
}
\value{
\code{eml.xml} file written to disk.
And invisibly, an \link[EML:eml]{EML::eml} object.
}
\description{
Transforms the metadata of a Camera Trap Data Package object to an
\href{https://eml.ecoinformatics.org/}{Ecological Metadata Language (EML)} file.
}
\section{Transformation details}{

Metadata are derived from what is provided in \code{x}.
The following properties are set:
\itemize{
\item \strong{title}: Title as provided in \code{x$title}.
\item \strong{type}: Set to \code{Occurrence} in keywords.
\item \strong{subtype}: Set to \code{Observation} in keywords.
\item \strong{update frequency}: Set to \code{unknown}.
\item \strong{description}: Description as provided in \code{x$description}.
If \code{derived_paragraph = TRUE} a generated paragraph is added, e.g.:

Data have been standardized to Darwin Core using the \href{https://inbo.github.io/camtrapdp/}{camtrapdp} R package and only include observations
(and associated media) of animals. Excluded are records that document blank
or unclassified media, vehicles and observations of humans.
\item \strong{license}: License with scope \code{data} as provided in \code{x$licenses}.
\item \strong{creators}: Contributors as provided in \code{x$contributors}, excluding those
with roles \code{rightsHolder} and \code{publisher}.
\item \strong{contact}: Contributors with role \code{contact}. If none exist, first
creator.
\item \strong{metadata provider}: Same as \code{contact}.
\item \strong{keywords}: Keywords as provided in \code{x$keywords}.
\item \strong{geographic coverage}: Bounding box as provided in \code{x$spatial}.
\item \strong{taxonomic coverage}: Taxa as provided in \code{x$taxonomic}.
\item \strong{temporal coverage}: Date range as provided in \code{x$temporal}.
\item \strong{project data}: Title, acronym as identifier, description, and sampling
design as provided in \code{x$project}.
\item \strong{alternative identifier}: Identifier as provided in \code{x$id}.
If this is a DOI, no new DOI will be created when publishing to GBIF.
\item \strong{external link}: URL of the project as provided in
\code{x$project$path}.
}

The following properties are not set:
\itemize{
\item \strong{publishing organization}
\item \strong{associated parties}
\item \strong{sampling methods}
\item \strong{citations}
\item \strong{collection data}: not applicable.
}
}

\examples{
x <- example_dataset()
(write_eml(x, directory = "my_directory"))

# Clean up (don't do this if you want to keep your files)
unlink("my_directory", recursive = TRUE)
}
\seealso{
Other transformation functions: 
\code{\link{merge_camtrapdp}()},
\code{\link{round_coordinates}()},
\code{\link{shift_time}()},
\code{\link{update_taxon}()},
\code{\link{write_dwc}()}
}
\concept{transformation functions}
