% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_dwc.R
\name{write_dwc}
\alias{write_dwc}
\title{Transform a Camera Trap Data Package to a Darwin Core Archive}
\usage{
write_dwc(x, directory)
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by \code{\link[=read_camtrapdp]{read_camtrapdp()}}.}

\item{directory}{Path to local directory to write files to.}
}
\value{
CSV and \code{meta.xml} files written to disk.
And invisibly, a list of data frames with the transformed data.
}
\description{
Transforms a Camera Trap Data Package object to a \href{https://dwc.tdwg.org/text/}{Darwin Core Archive}.
}
\section{Transformation details}{

This function \strong{follows recommendations} in Reyserhove et al. (2023)
\doi{10.35035/doc-0qzp-2x37} and transform data to:
\itemize{
\item An \href{https://docs.gbif.org/camera-trap-guide/en/#section-occurrence-core}{Occurrence core}.
\item An \href{https://docs.gbif.org/camera-trap-guide/en/#section-ac-extension}{Audubon/Audiovisual Media Description extension}.
\item A \code{meta.xml} file.
}

Key features of the Darwin Core transformation:
\itemize{
\item The Occurrence core contains one row per observation
(\code{dwc:occurrenceID = observationID}).
\item Only observations with \code{observationType = "animal"} and are included, thus
excluding observations that are (of) humans, vehicles, blanks, unknowns and
unclassified.
\item Either observations with \code{observationLevel = "event"} or \code{"media"} are
used, never both to avoid duplicates.
The level be defined with \code{x$gbifIngestion$observationLevel},
with \code{"event"} as default.
\item Observations classified by humans with 100\% certainty get a
\code{dwc:identificationVerificationStatus = "verified using recorded media"}.
\item Deployment information is included in the Occurrence core, such as
location, habitat, \code{dwc:samplingProtocol}, deployment duration in
\code{dwc:samplingEffort} and \code{dwc:parentEventID = deploymentID} as grouping
identifier.
\item Event information is included in the Occurrence core, as event duration in
\code{dwc:eventDate} and \code{dwc:eventID = eventID} as grouping identifier.
\item Media files are included in the Audubon/Audiovisual Media Description
extension, with a foreign key to the observation.
A media file that is used for more than one observation is repeated.
\item Metadata are used to set the following record-level terms:
\itemize{
\item \code{dwc:datasetID}: \code{x$id}.
\item \code{dwc:datasetName}: \code{x$title}.
\item \code{dwc:collectionCode}: first source in \code{x$sources}.
\item \code{dcterms:license}: license \code{name} (e.g. \code{CC0-1.0}) in \code{x$licenses} with
scope \code{data}.
The license \code{name} with scope \code{media} is used as \code{dcterms:rights} in the
Audubon Media Description extension.
\item \code{dcterms:rightsHolder}: first contributor in \code{x$contributors} with role
\code{rightsHolder}.
\item \code{dwc:dataGeneralizations}: set if \code{x$coordinatePrecision} is defined.
}
}
}

\examples{
x <- example_dataset()
write_dwc(x, directory = "my_directory")

# Clean up (don't do this if you want to keep your files)
unlink("my_directory", recursive = TRUE)
}
\seealso{
Other transformation functions: 
\code{\link{merge_camtrapdp}()},
\code{\link{round_coordinates}()},
\code{\link{shift_time}()},
\code{\link{update_taxon}()},
\code{\link{write_eml}()}
}
\concept{transformation functions}
