% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_camtrapdp.R
\name{write_camtrapdp}
\alias{write_camtrapdp}
\title{Write a Camera Trap Data Package to disk}
\usage{
write_camtrapdp(x, directory, ...)
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by \code{\link[=read_camtrapdp]{read_camtrapdp()}}.}

\item{directory}{Path to local directory to write files to.}

\item{...}{Further arguments, passed to \code{\link[frictionless:write_package]{frictionless::write_package()}}
(e.g. \code{compress = TRUE}).}
}
\value{
\code{datapackage.json} and CSV files written to disk.
}
\description{
Writes a Camera Trap Data Package and its related Data Resources to disk as a
\code{datapackage.json} and CSV files.
}
\examples{
x <- example_dataset()

# Filter (and therefore change) the dataset
x <- filter_deployments(x, deploymentID == "00a2c20d")

# Write the Camera Trap Data Package to disk
write_camtrapdp(x, directory = "my_directory")

# Check files
list.files("my_directory")

# Clean up (don't do this if you want to keep your files)
unlink("my_directory", recursive = TRUE)
}
\concept{write functions}
