% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deployments.R
\name{deployments}
\alias{deployments}
\alias{deployments<-}
\title{Get or set deployments}
\usage{
deployments(x)

deployments(x) <- value
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by \code{\link[=read_camtrapdp]{read_camtrapdp()}}.}

\item{value}{A data frame to assign as deployments.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} data frame with deployments.
}
\description{
\code{deployments()} gets the deployments from a Camera Trap Data Package object.

\verb{deployments()<-} is the assignment equivalent.
\itemize{
\item It should only be used within other functions, where the expected data
structure can be guaranteed.
\item Metadata (\code{x$spatial} and \code{x$temporal}) are updated to match the assigned
deployments.
}
}
\examples{
x <- example_dataset()
# Get deployments
deployments(x)

# Set deployments (not recommended outside a function)
deployments(x) <- head(deployments(x), 1)
}
\seealso{
Other accessor functions: 
\code{\link{contributors}()},
\code{\link{events}()},
\code{\link{individuals}()},
\code{\link{locations}()},
\code{\link{media}()},
\code{\link{observations}()},
\code{\link{taxa}()}
}
\concept{accessor functions}
