% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC.residuals.R
\name{PPC.residuals}
\alias{PPC.residuals}
\title{Calculate Residuals from MCMC Output of Occupancy Models}
\usage{
PPC.residuals(
  y,
  p,
  psi,
  model = c("Occupancy", "RN"),
  type = c("FT", "PearChi2", "Deviance"),
  K = NULL,
  z.cond = TRUE,
  zhat = NULL,
  nmax = 20,
  return.residuals = TRUE,
  return.z = TRUE
)
}
\arguments{
\item{y}{Observations as either a site vector or site by occasion matrix. For matrix 
format, use NA for unsampled occasions.}

\item{p}{Array of posterior samples for detection probability (p). Dimensions should be 
iterations by sites (by occasion optionally). For RN models, p should represent 
individual-level detection (not conditional on local abundance).}

\item{psi}{Array of posterior samples for occupancy probability (psi). Dimensions should 
be iterations by sites. For RN models, psi should represent expected abundance}

\item{model}{Character indicating model type: either "Occupancy" or "RN" 
(Royle-Nichols).}

\item{type}{Type of residual to calculate: "FT" (Freeman Tukey), "PearChi2" 
(Pearson Chi-squared), or "Deviance" (not technically a residual).}

\item{K}{Number of occasions as either a scalar or site vector. Calculated automatically 
if y is a matrix.}

\item{z.cond}{Logical. If TRUE, new data is conditioned on estimated z (testing only 
detection model fit). If FALSE, generates new z for each posterior sample 
(testing complete model).}

\item{zhat}{Optional matrix with same dimensions as psi containing estimates of z from 
the same model. If not provided, will be generated internally.}

\item{nmax}{Maximum site-level abundance (default = 20). Only used if model="RN". 
Higher values increase computation time. Warning given if set too low.}

\item{return.residuals}{Logical. If TRUE (default), returns residuals along with 
Bayesian p-value.}

\item{return.z}{Logical. If TRUE, returns z values conditional on y, and unconditional 
z's if \code{z.cond = FALSE}. Note: if zhat is provided, the returned conditional-on-y z 
values will be identical to those provided.}
}
\value{
If return.residuals=TRUE (default), returns a list containing:
  \itemize{
    \item res.obs - residuals for observed data
    \item res.new - residuals for newly generated data
    \item BP - Bayesian p-value
  }
  If return.residuals=FALSE, returns only the Bayesian p-value.
}
\description{
Posterior Predictive Check (PPC) function that calculates Freeman-Tukey (FT) 
residuals, Pearson"s Chi-squared residuals, or deviance from MCMC output of 
occupancy models. This function compares observed data to simulated data from 
the posterior distribution to assess model fit.
}
\details{
This function helps assess model fit for occupancy models using various types of residuals:

\subsection{Types of Residuals}{
  \itemize{
    \item Freeman-Tukey (FT):
          \deqn{R_j = (\sqrt{y_j} - \sqrt{E(y_j)})^2}
          Measures the squared difference between the square root 
          of observed detections and the square root of expected detections 
          at each site.
    \item Pearson Chi-squared:
          \deqn{R_j = \left(\frac{y_j - E(y_j)}{\sqrt{Var(y_j)}}\right)^2}
          Measures the squared difference between observed and 
          expected detections, standardized by the theoretical variance calculated 
          from the model parameters.
    \item Deviance:
          \deqn{R_j = -2\log[y_j|\theta_j, K_j]}
          Measures the contribution of each site to the overall model 
          likelihood, quantifying the discrepancy between observed data and model 
          predictions based on likelihood ratios
  }

  Where:
  \itemize{
    \item \eqn{y_j} is the number of detections of the species at site j, out of 
          \eqn{K_j} repeated surveys
    \item \eqn{E(y_j) = K_j p_j z_j}, with \eqn{p_j} = species detection probability 
          and \eqn{z_j} = occupancy state (1 if occupied, 0 otherwise)
    \item \eqn{Var(y_j) = p_j z_j (1 - p_j z_j) K_j}
    \item For Royle-Nichols occupancy models, the term \eqn{p_j z_j} is replaced with 
          \eqn{1 - (1 - r_j)^{N_j}}, where \eqn{r_j} = individual detection probability 
          and \eqn{N_j} = local abundance
    \item For Deviance, \eqn{\theta_j} is either occupancy and species detection probability 
          at site j (\eqn{\psi_j, p_j}) for regular occupancy models, or expected abundance 
          and individual detection probability (\eqn{\lambda_j, r_j}) for Royle-Nichols 
          occupancy models
  }
}

\subsection{Bayesian P-values}{
  The function calculates Bayesian p-values as a measure of model fit. These values:
  \itemize{
    \item Range from 0 to 1
    \item Values close to 0.5 suggest good model fit
    \item Values close to 0 or 1 suggest poor fit
    \item Are calculated by comparing observed residuals to residuals from 
          simulated data
  }
}

\subsection{Conditional vs Unconditional Assessment}{
  The z.cond parameter allows for two types of model assessment:
  \itemize{
    \item z.cond = TRUE: Tests only the detection component of the model, fixing 
          occupancy/abundance to estimates from the model, rather than generating them anew
    \item z.cond = FALSE: Tests the complete model, including both occupancy and 
          detection components
  }
}
}
\note{
FT and Chi-squared residuals have been extensively tested. Deviance calculations 
have undergone less testing and are only available for scenarios with constant 
detection probability across occasions. FT and Chi-squared residuals can handle 
varying detection probabilities.
}
\section{Warning}{
 This is a beta version of the function. While it has been tested extensively, 
  not all possible data configurations may have been captured in testing. This is 
  particularly true for:
  
  \itemize{
    \item Deviance calculations (type = "Deviance")
    \item Royle-Nichols models (model = "RN")
  }
  If you encounter issues with the function, please contact the package developers.
}

\references{
Sollmann, Rahel. Occupancy models and the "good fit, bad prediction" dilemma. 
Ecology (submitted)
}
\author{
Rahel Sollmann
}
