% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvhar-package.R
\docType{package}
\name{bvhar-package}
\alias{bvhar}
\alias{bvhar-package}
\title{bvhar: Bayesian Vector Heterogeneous Autoregressive Modeling}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Tools to model and forecast multivariate time series including Bayesian Vector heterogeneous autoregressive (VHAR) model by Kim & Baek (2023) (\doi{10.1080/00949655.2023.2281644}). 'bvhar' can model Vector Autoregressive (VAR), VHAR, Bayesian VAR (BVAR), and Bayesian VHAR (BVHAR) models.
}
\details{
The bvhar package provides function to analyze and forecast multivariate time series data via vector autoregressive modeling.
Here, vector autoregressive modelling includes:
\itemize{
\item Vector autoregressive (VAR) model: \code{\link[=var_lm]{var_lm()}}
\item Vector heterogeneous autoregressive (VHAR) model: \code{\link[=vhar_lm]{vhar_lm()}}
\item Bayesian VAR (BVAR) model: \code{\link[=var_bayes]{var_bayes()}}
\item Bayesian VHAR (BVHAR) model: \code{\link[=vhar_bayes]{vhar_bayes()}}
}
}
\references{
Kim, Y. G., and Baek, C. (2024). \emph{Bayesian vector heterogeneous autoregressive modeling}. Journal of Statistical Computation and Simulation, 94(6), 1139-1157.

Kim, Y. G., and Baek, C. (n.d.). Working paper.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://bvhar.baeconverse.org}
  \item \url{https://github.com/ygeunkim/bvhar}
  \item Report bugs at \url{https://github.com/ygeunkim/bvhar/issues}
}

}
\author{
\strong{Maintainer}: Young Geun Kim \email{ygeunkimstat@gmail.com} (\href{https://orcid.org/0000-0001-8651-1167}{ORCID}) [copyright holder]

Other contributors:
\itemize{
  \item Changryong Baek [contributor]
}

}
\keyword{internal}
