% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_dist.R
\name{boot_dist}
\alias{boot_dist}
\title{Bootstrap Distribution}
\usage{
boot_dist(
  boot_obj,
  comp = 1,
  PLT = TRUE,
  nn = TRUE,
  recenter = FALSE,
  return_values = FALSE
)
}
\arguments{
\item{boot_obj}{A bootstrap object of type \code{boodd}, containing the bootstrap samples.}

\item{comp}{A positive Integer; The index of the column of the bootstrap matrix to be plotted or analysed.}

\item{PLT}{Logical. If \code{TRUE} (default), the function plots the distribution.}

\item{nn}{Logical. If \code{TRUE} (default), a normal approximation is superimposed
on the histogram.}

\item{recenter}{Logical. If \code{TRUE}, the bootstrap distribution is recentered by
the bootstrap mean, else if \code{FALSE} (default)
it is recentered by the original value of the estimator.}

\item{return_values}{Logical. If \code{TRUE} the function returns the calculated values
for the rescaled and recentered distribution. \code{FALSE} by default.}
}
\value{
A numeric vector representing the rescaled and optionally recentered
bootstrap distribution of the selected component of the statistic.
}
\description{
This function computes the rescaled and recentered bootstrap
distribution from a given bootstrap object. It optionally plots this
distribution and superimposes a normal approximation for comparison.
}
\details{
The function modifies the bootstrap distribution by recentering it,
depending on value of  \code{recenter}
parameter and computes a standardized version of the selected component of the statistic.
If \code{PLT} is \code{TRUE}, it generates a histogram of the
standardized distribution with optional normal approximation overlay if \code{nn}
is \code{TRUE}.
}
\examples{
n=30
X=rnorm(n)
fun = function(x){
c(mean(x), var(x))}
boo=boots(X, fun, B=999)
# Recentered, rescaled bootstrap distribution of the first component - mean
boot_dist(boo, comp=1, recenter = TRUE) 
# Rescaled bootstrap distribution of the first component - variance
boot_dist(boo, comp=2) 
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.
}
\seealso{
\code{\link{plot.boodd}}.
}
\keyword{"Normal}
\keyword{Bootstrap}
\keyword{Recentering}
\keyword{Rescaling}
\keyword{approximation"}
