% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockboot.R
\name{blockboot}
\alias{blockboot}
\title{Block Bootstrap}
\usage{
blockboot(
  x,
  func,
  B,
  length.block = NULL,
  method = c("movingblock", "nonoverlapping", "circular", "stationary"),
  moon = NULL,
  replace = "TRUE",
  ...
)
}
\arguments{
\item{x}{A vector or a time series.}

\item{func}{The function to apply to each sample.}

\item{B}{A positive integer; the number of bootstrap replications.}

\item{length.block}{A positive integer; the length of the blocks.}

\item{method}{The block bootstrap method. The possible values of the \code{method} argument are:
\code{"movingblock"}, \code{"nonoverlapping"},
\code{"circular"} or \code{"stationary"}.
If it is not specified, the default method is \emph{"movingblock"}.
Method names may be abbreviated.}

\item{moon}{Integer or \code{NULL}. When \code{moon = NULL} (default), \code{blockboot}
performs a regular block bootstrap without subsampling.
If \code{moon} is equal to some integer value,
the function creates block bootstrap samples of size \code{moon}, drawing blocks of
length \code{length.block}.
Ensure that \code{moon} is less than
\code{n - 5}, where \code{n} is the size of the data.}

\item{replace}{Logical. If \code{replace = TRUE} (default), the function performs block
bootstrap with replacement. If \code{replace = FALSE}, it performs Block Bootstrap
Subsampling without replacement. In this case \code{moon} should be specified.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
An object of class \code{boodd}.
}
\description{
The function applies block bootstrap methods to a time series.

This function allows the following block bootstrap methods to be
used: the Moving Block Bootstrap (Kunsch (1989), Liu and Singh (1992)),
the Nonoverlapping Block Bootstrap (Carlstein (1986)), the Circular
Block Bootstrap (Politis and Romano (1992)), and the Stationary Bootstrap
(Politis and Romano (1994)).
}
\details{
Nonoverlapping Block Bootstrap (NBB) consists in cutting the original time
series into nonoverlapping blocks of fixed length \code{length.block} and in
resampling these blocks to reconstruct a
bootstrap time series.
Moving Block Bootstrap (MBB) consists in drawing independently overlapping blocks
of fixed size \code{length.block} to reconstruct a bootstrap time series of
length of the original process.
Circular Block Bootstrap (CBB) consists in wrapping the data on a circle and to
create the corresponding overlapping blocks, so that each value of the time series
appears globally the same number of times in all the blocks. This generally reduce the
bias of the bootstrap distribution.
Stationary Bootstrap (SB) is based on blocks with random length, which ensure that
the bootstrap sample is stationary.
}
\examples{
B <- 999
data(airquality)
x <- airquality$Wind
n <- length(x)
b <- floor(sqrt(n))
boo1 <- blockboot(x,mean,B,b,method="moving")
plot(boo1,main="MBB", nclass=30)
confint(boo1, method="all")
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Carlstein E. (1986). The use of subseries methods for
estimating the variance of a general statistic from a stationary time series.
\emph{Annals of Statist.}, \bold{14}, 1171-1179.

Künsch, H. (1989). The jackknife and the bootstrap for
general stationary observations. \emph{Ann. Statist.}, 17, 1217-1241.

Liu, R. and Singh, K. (1992). Moving block jackknife and
bootstrap capture weak dependence. \emph{Exploring the Limits of Bootstrap.},
Series in Probab. Math. Statist. Wiley, New York, pp 225-248.

Politis, D.N. and Romano, J.P. (1994). The stationary
bootstrap. \emph{J. Amer. Statist. Assoc.}, \bold{89}, 1303--1313.

Politis, D.N. and Romano, J.P. (1992).
A circular block-resampling procedure for stationary data.
\emph{Exploring the Limits of Bootstrap.},
Series in Probab. Math. Statist. Wiley, New York, pp 263-270.
}
\seealso{
{\code{\link{boots}},
\code{\link{bootsemi}},
\code{\link{plot.boodd}},
\code{\link{confint.boodd}},
\code{\link{fieldboot}},
\code{\link{jackVarBlock}}}.
}
\keyword{"Bootstrap"}
\keyword{"Moving}
\keyword{block"}
