% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_is_bipartite}
\alias{sim_is_bipartite}
\title{Reports whether the spatial interaction model is bipartite}
\usage{
sim_is_bipartite(sim)
}
\arguments{
\item{sim}{a spatial interaction model object}
}
\value{
\code{TRUE} if the spatial interaction model is bipartite, \code{FALSE} if
not.
}
\description{
The function returns \code{TRUE} is the spatial interaction model (SIM) is
bipartite, that is if the origin locations are distinct from the destination
locations (at least from the analysis point of view). The function return
\code{FALSE} when the SIM uses the same locations for origin and destination.
}
\examples{
positions <- matrix(rnorm(10 * 2), ncol = 2)
distances <- as.matrix(dist(positions))
production <- rep(1, 10)
attractiveness <- c(2, rep(1, 9))
model <- static_blvim(distances, production, 1.5, 1, attractiveness)
## returns TRUE despite the use of a single set of positions
sim_is_bipartite(model)
## now we are clear about the non bipartite nature of the model
model <- static_blvim(distances, production, 1.5, 1, attractiveness,
  bipartite = FALSE
)
sim_is_bipartite(model)
}
