% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarise_placebo_top3_posthoc}
\alias{summarise_placebo_top3_posthoc}
\title{Summarise top-3 temporal placebo results}
\usage{
summarise_placebo_top3_posthoc(placebo_tab, dir_csv)
}
\arguments{
\item{placebo_tab}{Optional data frame with placebo results, typically
containing columns \code{perm}, \code{elpd_orig}, \code{elpd_perm},
and \code{diff}. If \code{NULL} or empty, the function attempts to
read \code{"placebo_temporal.csv"} from \code{dir_csv}.}

\item{dir_csv}{Character scalar; directory where the placebo CSV file
is stored.}
}
\value{
A data frame with up to three rows and columns:
\itemize{
\item \code{model}: constant string \code{"PlaceboTemporal"}.
\item \code{config}: text of the form \code{"perm=<id>"}.
\item \code{elpd_orig}, \code{elpd_perm}, \code{diff}: original
ELPD, permuted ELPD, and their difference.
}
If no data are available, a single-row data frame with \code{NA}
entries is returned.
}
\description{
Summarises the three strongest temporal placebo results (based on
the difference between original and permuted ELPD) from a temporal
permutation test.
}
\details{
The table is ordered by decreasing \code{diff} (ELPD gain of the
original fit over the permuted fit), and the top three permutations
are retained.
}
