#' @title Data for Genotypes by Environment Interaction (GEI)
#' @name   cultivo2008
#' @docType data
#' @keywords datasets
#' @usage data(cultivo2008)
#' @description \code{cultivo2008} is used for performing Genotypes by Environment Interaction (GEI) Analysis.
#' @format A \code{data.frame} 1320 obs. of  6 variables.
#' @details
#'        \itemize{
#'        \item{Gen} Genotype
#'        \item{Institute} Institute
#'        \item{Rep} Replicate
#'        \item{Block} Block
#'        \item{Env} Environment
#'        \item{Yield} Yield Response
#'        }
#'
#' @author
#' \enumerate{
#'     \item Muhammad Yaseen (\email{myaseen208@gmail.com})
#'    \item Diego Jarquin (\email{diego.jarquin@gmail.com})
#'    \item Sergio Perez-Elizalde (\email{sergiop@colpos.mx})
#'    \item Juan Burgueño (\email{j.burgueno@cgiar.org})
#'    \item Jose Crossa (\email{j.crossa@cgiar.org})
#'    }
#'
#' @references
#'  Perez-Elizalde, S., Jarquin, D., and Crossa, J. (2011)
#'  A General Bayesian Estimation Method of Linear–Bilinear Models
#'  Applied to Plant Breeding Trials With Genotype × Environment Interaction.
#'  \emph{Journal of Agricultural, Biological, and Environmental Statistics},
#'   17, 15–37.  (\href{https://link.springer.com/article/10.1007/s13253-011-0063-9}{doi:10.1007/s13253-011-0063-9})
#'
#' @examples
#' data(cultivo2008)
#'
NULL
