% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup_column.R
\name{cleanup_column}
\alias{cleanup_column}
\title{Clean up the input data set}
\usage{
cleanup_column(
  x,
  name.var,
  id.var,
  date.var,
  nmv.var,
  gmv.var,
  pnl.var,
  contract.var,
  sector.var,
  strategy.var,
  substrategy.var,
  portfolio.var
)
}
\arguments{
\item{x}{is a data frame that contains the necessary information.}

\item{name.var}{is the column name of the instrument name column in the input 
data set, character type. The default value of this variable is "name". The user has to
specify name.var if she passes in a data frame with a different column name for the 
instrument name. The input data set must contain either a name column or an ID column.}

\item{id.var}{is the column name of the instrument ID column, character type. 
The default value of this variable is "id". If the input data set labels the
column of instrument ID's with some other column name, the user has to pass
in the column name here. The input data set has to contain either a name
column or an ID column.}

\item{date.var}{is the column name of the date column, character type. The
default value of this variable is "date". This column has to exist, and the
column name has to be correct in order for the function to process the data
set properly.}

\item{nmv.var}{is the column name of the "net market value" column, character 
type. The default value of this variable is "start.nmv". The input data set
has to contain either a "net market value" column or a "number of contract"
column.}

\item{gmv.var}{The column name of the "gross market value" column if exists, 
character type. The default value of this variable is "gmv". Such column will 
be automatically calculated from the "net market value" column if it does not 
exist.}

\item{pnl.var}{The column name of the profit-and-loss column, character type.
The default value of this variable is "pnl.adj". The data set has to contain
such column so that the function can function properly. If such column is
missing, the function will return an error indicating the problem.}

\item{contract.var}{The column name of the contract number column, character 
type. The default value of this variable is "num.contract.start". If such 
column is missing, the function will instead use net market value as the
contract number for each day.}

\item{sector.var}{is the column name of the sector column, character type. The
default value of this variable is "sector". The sector column helps the user
to group instruments into big groups according to industries. The function
will still perform properly if the column name for sector is wrong.}

\item{strategy.var}{The column name of the strategy column, if any. Character 
type. The default value of this variable is "strategy". This column can be
missing from the input data set.}

\item{substrategy.var}{The column name of the substrategy column, if any. 
Character type. The default value of this variable is "substrategy". This
column can be missing from the input data set.}

\item{portfolio.var}{The column name of the portfolio number column, if any. 
Character type. The default value of this variable is "portfolio". This
column can be missing from the input data set.}
}
\value{
x A data frame that only contains the needed data. The column names
are cleaned up here.
}
\description{
This function cleans up the input data set in the backtestGraphics function.
This function checks if all the columns required by the backtestGraphics
function exist in the input data set. If any columns are missing, this
function will try to calculate or fill in the missing columns. If the input
data set misses too much data/columns, this function will return an error 
indicating the missing columns.
}
