% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_hypothesis_test.R
\name{argmin.HT.nonsplit}
\alias{argmin.HT.nonsplit}
\title{Perform argmin hypothesis test.}
\usage{
argmin.HT.nonsplit(
  difference.matrix,
  lambda,
  sample.mean = NULL,
  alpha = 0.05,
  scale.input = TRUE
)
}
\arguments{
\item{difference.matrix}{A n by (p-1) difference data matrix (reference dimension - the rest);
each of its row is a (p-1)-dimensional vector of differences.}

\item{lambda}{The real-valued tuning parameter for exponential weightings (the calculation of softmin).}

\item{sample.mean}{The sample mean of differences; defaults to NULL. It can be calculated via colMeans(difference.matrix).}

\item{alpha}{The significance level of the hypothesis test; defaults to 0.05.}

\item{scale.input}{A boolean variable specifying whether the input difference matrix should be standardized defaults to TRUE}
}
\value{
A list containing:\tabular{ll}{
   \code{test.stat.scale} \tab The scaled test statistic \cr
   \tab \cr
.   \code{critical.value} \tab The critical value for the hypothesis test. Being greater than it leads to a rejection. \cr
   \tab \cr
   \code{std} \tab The standard deviation estimate. \cr
   \tab \cr
   \code{ans} \tab 'Reject' or 'Accept' \cr
}
}
\description{
Test if a dimension may be argmin without any splitting.
}
\details{
This method is not recommended, given its poor performance when p is small.
}
