% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{country_halos}
\alias{country_halos}
\title{Pre-computed Equal-Area Country Halos}
\format{
A named list with ISO3 country codes as names. Each element is
either an \code{sfc} geometry (POLYGON or MULTIPOLYGON) in WGS84, or NULL
if computation failed for that country.
}
\source{
Computed from Natural Earth country polygons and land mask.
}
\usage{
country_halos
}
\description{
A named list of pre-computed halo geometries for each country where the
halo area equals the country area (area proportion = 1). These halos
account for land masking (sea areas excluded).
}
\details{
Each halo is a "donut" shape: the area between the original country
boundary and the expanded boundary, clipped to land.
}
\examples{
# Get France's equal-area halo
france_halo <- country_halos[["FRA"]]

}
\keyword{datasets}
