% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{arc_spatial_references}
\alias{arc_spatial_references}
\title{ESRI (ArcGIS) Spatial Reference data base}
\format{
A \link[tibble:tbl_df-class]{tibble} with
9,608 rows
and fields:
\describe{
\item{projtype}{Projection type (\verb{"ProjectedCoordinateSystems", "GeographicCoordinateSystems","VerticalCoordinateSystems"})}
\item{wkid}{Well-Known ID}
\item{latestWkid}{Most recent \code{wkid}, in case that \code{wkid} is deprecated}
\item{authority}{\code{wkid} authority (Esri or EPSG)}
\item{deprecated}{Logical indicating if \code{wkid} is deprecated}
\item{description}{Human-readable description of the \code{wkid}}
\item{areaname}{Use area of the \code{wkid}}
\item{wkt}{Representation of \code{wkid} in Well-Known Text (WKT). Useful when
working with \CRANpkg{sf} or \CRANpkg{terra}}
}
}
\source{
\href{https://github.com/Esri/projection-engine-db-doc}{ESRI Projection Engine factory}
}
\description{
Database of available spatial references (CRS) in \link[tibble:tbl_df-class]{tibble}
format.
}
\details{
This data base is useful when using the \code{outsr} argument of the functions.

Some projections ids have changed over time, for example Web Mercator is
\code{wkid  = 102100} is deprecated and currently is \code{wkid = 3857}. However, both
values would work, and they would return similar results.
}
\note{
Data extracted on \strong{15 January 2026}.
}
\examples{
\dontshow{if (arcgeocoder_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
# Get all possible values
data("arc_spatial_references")
arc_spatial_references

# Request with deprecated Web Mercator
library(dplyr)
wkid <- arc_spatial_references |>
  filter(latestWkid == 3857 & deprecated == TRUE) |>
  slice(1)

glimpse(wkid)

add <- arc_geo("London, United Kingdom", outsr = wkid$wkid)

# Note values lat, lon and wkid. latestwkid give the current valid wkid
add |>
  select(lat, lon, wkid, latestWkid) |>
  glimpse()

# See with sf

try(sf::st_crs(wkid$wkid))

# But
try(sf::st_crs(wkid$latestWkid))

# or
try(sf::st_crs(wkid$wkt))
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[sf:st_crs]{sf::st_crs()}}

Other datasets: 
\code{\link{arc_categories}}
}
\concept{datasets}
