% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_add.R
\name{tags_add}
\alias{tags_add}
\title{Add a tag to a component}
\usage{
tags_add(
  company_id = Sys.getenv("AW_COMPANY_ID"),
  componentId = NULL,
  componentType = NULL,
  tagNames = NULL,
  overwrite = FALSE,
  debug = FALSE
)
}
\arguments{
\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link{get_me}} to get a list of available \code{company_id} values.}

\item{componentId}{The component id being requested. Default is \code{NULL}}

\item{componentType}{The component type being requested. Options include segment, dashboard, bookmark,
calculatedMetric, project, dateRange, metric, dimension, virtualReportSuite, scheduledJob, alert, classification.
Default is NULL}

\item{tagNames}{Comma separated vector of tag names.}

\item{overwrite}{Overwrite the existing tag names on a component. To append a
new tag name use FALSE (default). To overwrite the existing tags on a component
use TRUE.}

\item{debug}{Include the output and input of the api call in the console for debugging. Default is FALSE}
}
\value{
A data frame of segments and their meta data.
}
\description{
Enables the creation of a new tag and applies the new tag to the passed component
}
