% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/win_fft.R
\name{win_fft}
\alias{win_fft}
\title{Windowed fft based spectral analysis}
\usage{
win_fft(
  data = NULL,
  padfac = 5,
  window_size = NULL,
  run_multicore = FALSE,
  genplot = FALSE,
  x_lab = c("depth (m)"),
  y_lab = c("frequency cycle/metre"),
  plot_res = 1,
  perc_vis = 0,
  freq_max = NULL,
  freq_min = NULL,
  palette_name = "rainbow",
  color_brewer = "grDevices",
  keep_editable = FALSE,
  verbose = FALSE,
  dev_new = FALSE
)
}
\arguments{
\item{data}{Input data set  should consist of a matrix with 2 columns with
first column being depth and the second column being a proxy}

\item{padfac}{Pad record with zero, zero padding smooths out the spectra}

\item{window_size}{size of the running window}

\item{run_multicore}{Run function using multiple cores \code{Default="FALSE"}}

\item{genplot}{Generate plot \code{Default="FALSE"}}

\item{x_lab}{label for the y-axis \code{Default="depth"}}

\item{y_lab}{label for the y-axis \code{Default="sedrate"}}

\item{plot_res}{plot 1 of 8 options option 1: Amplitude matrix,
option 2: Power matrix,
option 3: Phase matrix,
option 4: AR1_CL matrix,
option 5: AR1_Fit matrix ,
option 6: AR1_90_power matrix,
option 7: AR1_95_power matrix,
option 8: AR1_99_power matrix, \code{Default=1}}

\item{perc_vis}{Cutoff percentile when plotting \code{Default=0}}

\item{freq_max}{Maximum frequency to plot}

\item{freq_min}{Minimum frequency to plot}

\item{palette_name}{Name of the color palette which is used for plotting.
The color palettes than can be chosen depends on which the R package is specified in
the color_brewer parameter. The included R packages from which palettes can be chosen
from are; the 'RColorBrewer', 'grDevices', 'ColorRamps' and 'Viridis' R packages.
There are many options to choose from so please
read the documentation of these packages \code{Default=rainbow}.
The R package 'viridis' has the color palette options: “magma”, “plasma”,
“inferno”, “viridis”, “mako”, and “rocket”  and “turbo”
To see the color palette options of the The R pacakge 'RColorBrewer' run
the RColorBrewer::brewer.pal.info() function
The R package 'colorRamps' has the color palette options:"blue2green",
"blue2green2red", "blue2red",    "blue2yellow", "colorRamps",    "cyan2yellow",
"green2red", "magenta2green", "matlab.like", "matlab.like2" and    "ygobb"
The R package 'grDevices' has the built in  palette options:"rainbow",
"heat.colors", "terrain.colors","topo.colors" and "cm.colors"
To see even more color palette options of the The R pacakge 'grDevices' run
the grDevices::hcl.pals() function}

\item{color_brewer}{Name of the R package from which the color palette is chosen from.
The included R packages from which palettes can be chosen
are; the RColorBrewer, grDevices, ColorRamps and Viridis R packages.
There are many options to choose from so please
read the documentation of these packages. "\code{Default=grDevices}}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}

\item{verbose}{Print text \code{Default=FALSE}.}

\item{dev_new}{Opens a new plotting window to plot the plot, this
guarantees  a "nice" looking plot however when plotting in an R markdown
document the plot might not plot  \code{Default=FALSE}}
}
\value{
Returns a list which contains 10 elements
element 1: Amplitude matrix
element 2: Power matrix
element 3: Phase matrix
element 4: AR1_CL matrix
element 5: AR1_Fit matrix
element 6: AR1_90_power matrix
element 7: AR1_95_power matrix
element 8: AR1_99_power matrix
element 9: depth
element 10: y_axis
If genplot is \code{Default=TRUE} then a plot of one of the elements 1:8 is plotted
}
\description{
The \code{\link{win_fft}} function for conducts a windowed spectral analysis based on the fft
}
\examples{
\donttest{
#Conduct a windowed ftt on the magnetic susceptibility record
#of the Sullivan core of Pas et al., (2018).

mag_win_fft <- win_fft(data= mag,
                   padfac = 5,
                   window_size = 12.5,
                   run_multicore = FALSE,
                   genplot = FALSE,
                   x_lab = c("depth (m)"),
                   y_lab = c("frequency cycle/metre"),
                   plot_res = 1,
                   perc_vis = 0.5,
                   freq_max = 5,
                   freq_min = 0.001,
                   palette_name ="rainbow",
                   color_brewer= "grDevices",
                   keep_editable=FALSE,
                   verbose=FALSE,
                   dev_new=FALSE)
}

}
\references{
Routines for astrochronologic testing, astronomical time scale construction, and
time series analysis <doi:10.1016/j.earscirev.2018.11.015>
}
\author{
Based on the \link[astrochron]{periodogram}
function of the 'astrochron' R package.
}
