% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic_extraction.R
\name{dynamic_extraction}
\alias{dynamic_extraction}
\title{Extract a signal in between tracked boundaries in a wavelet scalogram}
\usage{
dynamic_extraction(
  wavelet = NULL,
  n.levels = 100,
  add_peaks = FALSE,
  periodlab = "Period (metres)",
  x_lab = "depth (metres)",
  palette_name = "rainbow",
  color_brewer = "grDevices",
  plot_horizontal = TRUE,
  smooth = FALSE,
  add_mean = TRUE
)
}
\arguments{
\item{wavelet}{Wavelet object created using the \code{\link{analyze_wavelet}} function.}

\item{n.levels}{Number of color levels \code{Default=100}.}

\item{add_peaks}{Setting which indicates whether spectral peaks should be
added to the tracking plot  \code{Default=FALSE}.}

\item{periodlab}{label for the y-axis \code{Default="Period (metres)"}.}

\item{x_lab}{label for the x-axis \code{Default="depth (metres)"}.}

\item{palette_name}{Name of the color palette which is used for plotting.
The color palettes than can be chosen depends on which the R package is specified in
the color_brewer parameter. The included R packages from which palettes can be chosen
from are; the 'RColorBrewer', 'grDevices', 'ColorRamps' and 'Viridis' R packages.
There are many options to choose from so please
read the documentation of these packages \code{Default=rainbow}.
The R package 'viridis' has the color palette options: “magma”, “plasma”,
“inferno”, “viridis”, “mako”, and “rocket”  and “turbo”
To see the color palette options of the The R pacakge 'RColorBrewer' run
the RColorBrewer::brewer.pal.info() function
The R package 'colorRamps' has the color palette options:"blue2green",
"blue2green2red", "blue2red",    "blue2yellow", "colorRamps",    "cyan2yellow",
"green2red", "magenta2green", "matlab.like", "matlab.like2" and    "ygobb"
The R package 'grDevices' has the built in  palette options:"rainbow",
"heat.colors", "terrain.colors","topo.colors" and "cm.colors"
To see even more color palette options of the The R pacakge 'grDevices' run
the grDevices::hcl.pals() function}

\item{color_brewer}{Name of the R package from which the color palette is chosen from.
The included R packages from which palettes can be chosen
are; the RColorBrewer, grDevices, ColorRamps and Viridis R packages.
There are many options to choose from so please
read the documentation of these packages. "\code{Default=grDevices}}

\item{plot_horizontal}{plot the wavelet horizontal or vertical eg y axis is depth or y axis power  \code{Default=TRUE}}

\item{smooth}{smooth the tracked period using the "loess_auto" function}

\item{add_mean}{add the mean to the extracted signal}
}
\value{
Results of the tracking of a cycle in the wavelet spectra is a matrix with 3 columns.
The first column is depth/time
The second column is the extracted tracked cycle
The third column is upper tracked period
The fourth column is lower tracked period
}
\description{
Interactively select points in a wavelet scalogram to trace the upper and
lower period of an cycle.  The \code{\link{dynamic_extraction}} function plots a wavelet scalogram in which points peaks can selected
allowing one to track the lower and upper period of a cycle. First track the upper or lower period of the to
be extracted cycle and then track the other boundary. Tracking points can be selected in the Interactive interface and will be shown as white dots
connected by a black line. When one wants to deselect a point the white dots can be re-clicked/re-selected and will turn red which
indicates that the previously selected point is deselected. Deselecting points can be quite tricky.
After tracking the lower and upper boundaries of the cycle the \code{\link{dynamic_extraction}} function
will extract the signal in between the boundaries. the output can then used as input for the
\code{\link{minimal_tuning}} function to create an age model.
}
\examples{
\dontrun{
#Track the 405kyr upper and lower periods of the eccentricity cycle in the
#magnetic susceptibility record of the Sullivan core of Pas et al., (2018)

mag_wt <- analyze_wavelet(
 data = mag,
 dj = 1 / 100,
 lowerPeriod = 0.1,
 upperPeriod = 254,
 verbose = FALSE,
 omega_nr = 10
)

mag_ext <- dynamic_extraction(
 wavelet = mag_wt,
 n.levels = 100,
 add_peaks = FALSE,
 periodlab = "Period (metres)",
 x_lab = "depth (metres)",
 palette_name = "rainbow",
 color_brewer = "grDevices",
 plot_horizontal = TRUE,
 smooth = TRUE,
 add_mean = TRUE
)
}

}
\references{
Routines for astrochronologic testing, astronomical time scale construction, and
time series analysis <doi:10.1016/j.earscirev.2018.11.015>
}
\author{
The function is based/inspired on the \link[astrochron]{traceFreq}
function of the 'astrochron' R package
}
