% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphrag.R
\name{GraphRAGPipeline}
\alias{GraphRAGPipeline}
\title{GraphRAG Pipeline}
\description{
Complete GraphRAG processing pipeline
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{config}}{GraphRAGConfig}

\item{\code{graph}}{KnowledgeGraph}

\item{\code{communities}}{Detected communities}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GraphRAGPipeline-new}{\code{GraphRAGPipeline$new()}}
\item \href{#method-GraphRAGPipeline-process}{\code{GraphRAGPipeline$process()}}
\item \href{#method-GraphRAGPipeline-search}{\code{GraphRAGPipeline$search()}}
\item \href{#method-GraphRAGPipeline-stats}{\code{GraphRAGPipeline$stats()}}
\item \href{#method-GraphRAGPipeline-clone}{\code{GraphRAGPipeline$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphRAGPipeline-new"></a>}}
\if{latex}{\out{\hypertarget{method-GraphRAGPipeline-new}{}}}
\subsection{Method \code{new()}}{
Create a new GraphRAGPipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphRAGPipeline$new(config = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{GraphRAGConfig}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphRAGPipeline-process"></a>}}
\if{latex}{\out{\hypertarget{method-GraphRAGPipeline-process}{}}}
\subsection{Method \code{process()}}{
Process documents
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphRAGPipeline$process(texts, document_ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{texts}}{Character vector of documents}

\item{\code{document_ids}}{Document IDs}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphRAGPipeline-search"></a>}}
\if{latex}{\out{\hypertarget{method-GraphRAGPipeline-search}{}}}
\subsection{Method \code{search()}}{
Search the graph
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphRAGPipeline$search(query, search_type = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query string}

\item{\code{search_type}}{"local", "global", or "hybrid"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Search result
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphRAGPipeline-stats"></a>}}
\if{latex}{\out{\hypertarget{method-GraphRAGPipeline-stats}{}}}
\subsection{Method \code{stats()}}{
Get statistics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphRAGPipeline$stats()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphRAGPipeline-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GraphRAGPipeline-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphRAGPipeline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
