% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_selection_utils.R
\name{select_soft_power}
\alias{select_soft_power}
\title{Select the best soft-thresholding power for WGCNA}
\usage{
select_soft_power(
  data_matrix,
  r2_threshold = 0.8,
  make_plots = FALSE,
  output_dir = tempdir()
)
}
\arguments{
\item{data_matrix}{Numeric matrix/data frame (rows = samples, cols = features).}

\item{r2_threshold}{Target \eqn{R^2} for the scale-free model (default 0.8).}

\item{make_plots}{Logical; if \code{TRUE}, write diagnostic PNGs.}

\item{output_dir}{Output directory for plots when \code{make_plots = TRUE}. Defaults to \code{tempdir()} to comply with CRAN policies.}
}
\value{
Integer scalar: the selected soft-thresholding power.
}
\description{
Analyze scale-free topology fit across candidate powers and choose the
soft-thresholding power \eqn{\beta}.
}
\details{
The function uses a two-stage heuristic:
\enumerate{
\item Choose the smallest \eqn{\beta} whose scale-free fit \eqn{R^2}
exceeds \code{r2_threshold}.
\item If no power reaches the target \eqn{R^2}, select the smallest power
at the elbow of the curve, approximated by the discrete second
derivative
\deqn{\Delta^2 f(p_i) = f(p_{i+1}) - 2 f(p_i) + f(p_{i-1}),}
and pick the \eqn{p_i} with the largest \eqn{|\Delta^2 f(p_i)|}.
}
}
\examples{
# --- 1. Create a small synthetic data matrix ---
set.seed(123)
example_data <- matrix(rnorm(50 * 100), nrow = 50, ncol = 100)

# --- 2. Run the function to get the selected power ---
best_power <- select_soft_power(example_data)
print(paste("Best soft power:", best_power))

}
