% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_weighted_bar}
\alias{plot_weighted_bar}
\title{Create weighted bar plot for categorical variables}
\usage{
plot_weighted_bar(data, col, weight_col = NULL, show_percentages = TRUE)
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{col}{Character string specifying column name for categorical variable}

\item{weight_col}{Character string specifying column name containing weights (optional)}

\item{show_percentages}{Logical whether to show percentage labels (default: TRUE)}
}
\value{
A ggplot object
}
\description{
This function creates a bar plot for categorical variables, optionally
using survey weights to show weighted frequencies.
}
\examples{
data <- data.frame(gender = c("M", "F", "M", "F"), weight = c(1, 1.2, 0.8, 1.1))
bar_plot <- plot_weighted_bar(data, "gender")
weighted_bar <- plot_weighted_bar(data, "gender", "weight")
}
