% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{apply_weights}
\alias{apply_weights}
\title{Apply survey weights to data}
\usage{
apply_weights(data, weight_col)
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{weight_col}{Character string specifying column name containing weights}
}
\value{
A data.frame with normalized weights
}
\description{
This function applies survey weights by creating a weighted version of the dataset.
The weights are normalized to sum to the sample size for computational stability.
}
\examples{
data <- data.frame(age = c(25, 30, 35), weight = c(1.2, 0.8, 1.0))
weighted_data <- apply_weights(data, "weight")
}
