SIMEX_S1_trans = function(surv, status, X, Sigma_e, psi, k, r) {
##### Some prilimenary functions
Rt.fun <-
function(status,s0,ord.wt){
    Rt = cumsum(ord.wt*status/s0)
    return(Rt)
}

S02.fun <-
function(ord.bz,Rt,r,n,ord.wt){
    Rt0 = c(0,Rt[1:(n-1)])
    s0 = numeric(n)

    for(i in 1:n){
          a = ord.wt*exp(-ord.bz)/(1+r*Rt0[i]*exp(-ord.bz))
          s0[i] = sum(a[i:n])
    }
    return(s0)
}

Ubeta2.fun <-
function(status,ord.z,ord.bz,Rt,r,ord.wt){
    if(r > 0) a = ord.z*ord.wt*(status-(1/r)*log(1+r*Rt*exp(-ord.bz)))
    b = apply(a,2,sum)
    return(b)
}

####################

##### Steup
n = dim(X)[1]
p = dim(X)[2]
mu_e = rep(0,p)
Sigma_e = Sigma_e

y = surv; status = status
W = X
e = mvrnorm(n, mu_e, Sigma_e, tol = 1e-6, empirical = FALSE, EISPACK = FALSE)
ord.z = W + sqrt(psi) * e
ord.z = scale(ord.z)
W_G = NULL
for(k in 1:n) {
graph =  as.numeric(ord.z[k,]) %*% t(as.numeric(ord.z[k,]))
graph = graph - diag(diag(graph))
W_G = rbind(W_G, c(graph))
}

#####################
    ord.wt = y
    beta.ini = rep(0,p)
    theta.ini = rep(0,p^2)
    BETA = beta.ini
    THETA = theta.ini
    Rt.ini = cumsum(1/(n:1))
    dx = 0.01
    iter.max = 1000
    lambda = 0.01
    dif = 1
    iter = 0
    while(dif > dx & iter <= iter.max){
        ord.bz = as.numeric(ord.z%*%beta.ini + W_G%*%theta.ini)

           s0 = S02.fun(ord.bz,Rt.ini,r,n,ord.wt)
           Rt = Rt.fun(status,s0,ord.wt)
           Ubeta = Ubeta2.fun(status,ord.z,ord.bz,Rt,r,ord.wt)
           id = which(abs(Ubeta) == max(abs(Ubeta)))
           beta = beta.ini
           beta[id] = beta.ini[id] - sign(Ubeta)[id]*lambda
           #####
           ord.Gz = as.numeric(ord.z%*%beta + W_G%*%theta.ini)
           Ubeta_G = Ubeta2.fun(status,W_G,ord.Gz,Rt,r,ord.wt)
           id_G = which(abs(Ubeta_G) == max(abs(Ubeta_G)))
           theta = theta.ini
           theta[id_G] = theta.ini[id_G] - sign(Ubeta_G)[id_G]*lambda
           Rt.ini = Rt

           ord.bz_new = as.numeric(ord.z%*%beta + W_G%*%theta)
           Ubeta_new = Ubeta2.fun(status,cbind(ord.z,W_G),ord.bz_new,Rt,r,ord.wt)
        dif = max(abs(Ubeta_new-Ubeta))
        iter = iter + 1
        beta.ini = beta
        theta.ini = theta
        BETA = rbind(BETA,beta.ini)
    }

#BETA
return(  c(beta.ini, theta.ini) )


}


#### check the numerical results with 'TransModel' package
#data = data.frame(cbind(Y,status,ord.z))
#Trans = TransModel(formula = Surv(Y,status)~., data = data,r=1)


