% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_FindAllMarkers.R
\name{supercell_FindMarkers}
\alias{supercell_FindMarkers}
\title{Differential expression analysis of supep-cell data. Most of the parameters are the same as in Seurat \link[Seurat]{FindMarkers} (for simplicity)}
\usage{
supercell_FindMarkers(
  ge,
  supercell_size = NULL,
  clusters,
  ident.1,
  ident.2 = NULL,
  genes.use = NULL,
  logfc.threshold = 0.25,
  min.expr = 0,
  min.pct = 0.1,
  seed = 12345,
  only.pos = FALSE,
  return.extra.info = FALSE,
  do.bootstrapping = FALSE
)
}
\arguments{
\item{ge}{gene expression matrix for super-cells (rows - genes, cols - super-cells)}

\item{supercell_size}{a vector with supercell size (ordered the same way as in \code{ge})}

\item{clusters}{a vector with clustering information (ordered the same way as in \code{ge})}

\item{ident.1}{name(s) of cluster for which markers are computed}

\item{ident.2}{name(s) of clusters for comparison. If \code{NULL} (defauld), then all the other clusters used}

\item{genes.use}{set of genes to test. Defeult -- all genes in \code{ge}}

\item{logfc.threshold}{log fold change threshold for genes to be considered in the further analysis}

\item{min.expr}{minimal expression (default 0)}

\item{min.pct}{remove genes with lower percentage of detection from the set of genes which will be tested}

\item{seed}{random seed to use}

\item{only.pos}{whether to compute only positive (upregulated) markers}

\item{return.extra.info}{whether to return extra information about test and its statistics. Default is FALSE.}

\item{do.bootstrapping}{whether to perform bootstrapping when computing standard error and p-value in \link[weights]{wtd.t.test}}
}
\value{
a matrix with a test name (t-test), statisctics, adjusted p-values, logFC, percenrage of detection in eacg ident and mean expresiion
}
\description{
Differential expression analysis of supep-cell data. Most of the parameters are the same as in Seurat \link[Seurat]{FindMarkers} (for simplicity)
}
