% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterx.R
\name{filterx}
\alias{filterx}
\title{Filter a time series to reduce the short-memory dynamics using a low-order ARFIMA model}
\usage{
filterx(x, n = NULL)
}
\arguments{
\item{x}{A numeric vector containing the time series to be filtered.}

\item{n}{An integer giving the length of the filtered series. If \code{NULL},
the length of \code{x} is used.}
}
\value{
A numeric vector of length \code{n} containing the filtered series.
}
\description{
Fits ARFIMA(p, d, q) models with \eqn{p, q \in \{0, 1\}} using
\code{\link[fracdiff]{fracdiff}}, selects the specification by AIC,
and applies the corresponding linear filter to the series.
}
\details{
The function considers ARFIMA(1, d, 1), ARFIMA(1, d, 0), ARFIMA(0, d, 1),
and ARFIMA(0, d, 0) models, computes AIC for each, and selects the model
with the smallest AIC. If the absolute value of the selected AR or MA
coefficient is greater than or equal to 0.99, the procedure selects
a pure fractional model ARFIMA(0, d, 0). The input series is centered
before estimation.
}
\examples{
set.seed(123)
sim <- fracdiff::fracdiff.sim(
n = 1000,
ar = 0.3,     # AR(1) coefficient
ma = -0.4,    # MA(1) coefficient
d  = 0.25     # fractional differencing parameter
)
x <- sim$series
y <- filterx(x)
}
