% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catch_advice.R
\name{catch_advice}
\alias{catch_advice}
\title{catch_advice}
\usage{
catch_advice(
  Cy = NULL,
  TBA = NULL,
  SAM = NULL,
  T1 = NULL,
  T2 = NULL,
  plot = FALSE
)
}
\arguments{
\item{Cy}{Numeric (length 1) > 0. Most recent annual catch, or multi-year average.
If landing size restrictions have changed, use \code{catch_adjust} to adjust
the starting catch value accordingly.}

\item{TBA}{Numeric (length 1) > 0. Targeted Biomass Adjustment (see \code{TBA()}).}

\item{SAM}{Numeric (length 1) > 0. Size Adherence Multiplier (see \code{SAM()}).}

\item{T1}{Optional numeric (length 1) in (0,1). Maximum allowed proportional
\emph{decrease}. If \code{NULL}, no lower cap.}

\item{T2}{Optional numeric (length 1) in (0,1). Maximum allowed proportional
\emph{increase}. If \code{NULL}, no upper cap.}

\item{plot}{Logical. If \code{TRUE}, return a \pkg{ggplot2} heatmap (default \code{FALSE}).}
}
\value{
\itemize{
\item \code{Ay}: Catch advice (same units as \code{Cy}).
\item \code{Ay_percent}: Percent change of advice relative to \code{Cy}.
\item \code{plot}: (only when \code{plot = TRUE}) a \pkg{ggplot2} object
visualizing percent change across \eqn{TBA \times SAM}.
}
}
\description{
Calculates the advised catch using the SlotLim framework and (optionally) returns
a plot of the percentage change relative to \code{Cy} across a grid of
(\code{TBA}, \code{SAM}) values, with the output overlaid.
}
\examples{
Cy <- 1000; TBA <- 1.1; SAM <- 0.9
catch_advice(Cy, TBA, SAM)  # compute only

\donttest{
catch_advice(Cy, TBA, SAM, plot = TRUE)
catch_advice(Cy, TBA, SAM, T1 = 0.2, T2 = 0.2, plot = TRUE)
}

}
\seealso{
\code{\link{TBA}}, \code{\link{SAM}}
}
