% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stats.R
\name{wise_sim}
\alias{wise_sim}
\title{Calculate an n by n similarity matrix}
\usage{
wise_sim(data, measure = "distance", metric = "manhattan", k = NULL)
}
\arguments{
\item{data}{an n by p data matrix, with n being the sample size and p being the dimension.}

\item{measure}{the similarity measure: "distance" for distance-based measure; "graph" for k-nearest neighbor graph-based measure. The default is "distance".}

\item{metric}{character string specifying the distance metric or graph weight. "manhattan" for Manhattan distance (default), "euclidean" for Euclidean distance.}

\item{k}{the Number of nearest neighbors used in k-nearest neighbor graph. k = floor(sqrt(n)) if not specified.}
}
\value{
an n by n similarity matrix.
}
\description{
Returns an n by n similarity matrix.
}
\examples{
X <- matrix(rnorm(100), nrow = 10)
wise_sim(X, measure = "distance", metric = "manhattan")
}
