% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiparMF.R
\name{.semipar_internal}
\alias{.semipar_internal}
\title{Internal Computational Function for SemiparMF}
\usage{
.semipar_internal(y, x_high, z_low, w_mat, max_iter = 50, tol = 1e-04, ...)
}
\arguments{
\item{y}{Numeric matrix (N x T). The response variable in wide format (rows=locations, cols=time).}

\item{x_high}{Numeric array (N x T x K). The high-frequency covariate.
\itemize{
\item N: Number of spatial locations.
\item T: Number of low-frequency time points (matching \code{y}).
\item K: Frequency ratio (e.g., 3 for monthly data predicting quarterly response).
}}

\item{z_low}{Numeric matrix (N x T). The parametric covariate (same frequency as \code{y}).}

\item{w_mat}{Numeric matrix (N x T). The spatial neighborhood covariate (e.g., spatial lag of Z).}

\item{max_iter}{Integer. Maximum number of backfitting iterations. Default is 50.}

\item{tol}{Numeric. Convergence tolerance based on percentage change in Mean Squared Prediction Error (MSPE). Default is 1e-4.}

\item{...}{Additional arguments passed to \code{\link[stats]{smooth.spline}} (e.g., \code{spar}).}
}
\value{
A list containing:
\item{coefficients}{List of scalar estimates: \code{beta} (covariate effect), \code{gamma} (spatial effect), and \code{rho} (temporal autocorrelation).}
\item{nonparam}{List containing the \code{spline} object and \code{f_hat} (estimated non-parametric component).}
\item{residuals}{Matrix (N x T) of pure structural residuals \eqn{(Y - \hat{Y})}.}
\item{fitted.values}{Matrix (N x T) of fitted values.}
\item{history}{Vector of MSPE values per iteration.}
\item{iters}{Number of iterations performed.}
}
\description{
Implements the iterative backfitting algorithm with Cochrane-Orcutt updates as described
in Malabanan et al. (2022). This function handles the core estimation loop, separating
the non-parametric spline component from the parametric and temporal components.
}
\references{
Malabanan, V. A., Lansangan, J. R. G., & Barrios, E. B. (2022). Semiparametric Spatiotemporal Model with Mixed Frequencies: With
Application in Crop Forecasting. \emph{Science & Engineering Journal}, 15(2), 90-107.
}
\keyword{internal}
