% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_DATA.beta.R
\name{simulation_DATA.beta}
\alias{simulation_DATA.beta}
\title{Simulate \strong{interval} Beta-regression data (flexible)}
\usage{
simulation_DATA.beta(
  n,
  p,
  s = min(5L, p),
  beta_size = 1,
  a0 = 0,
  X_dist = c("gaussian", "t", "bernoulli"),
  corr = c("indep", "ar1", "block"),
  rho = 0,
  block_size = 5L,
  df = 5,
  prob = 0.5,
  active_idx = NULL,
  phi = 20,
  mechanism = c("jitter", "quantile", "mixed"),
  mix_prob = 0.5,
  delta = 0.05,
  delta_low = NULL,
  delta_high = NULL,
  alpha = 0.1,
  alpha_low = NULL,
  alpha_high = NULL,
  na_rate = 0,
  na_side = c("random", "left", "right"),
  centerX = FALSE,
  scaleX = FALSE,
  seed = NULL
)
}
\arguments{
\item{n, p}{Sample size and number of predictors.}

\item{s}{Number of active (nonzero) coefficients.}

\item{beta_size}{Scalar (alternating ±) or numeric vector of length greater then equal s.}

\item{a0}{Intercept (logit scale).}

\item{X_dist}{Distribution for X: \code{"gaussian"}, \code{"t"}, or \code{"bernoulli"}.}

\item{corr}{Correlation structure: \code{"indep"}, \code{"ar1"}, or \code{"block"}.}

\item{rho}{AR(1) correlation or within-block correlation.}

\item{block_size}{Block size when \code{corr = "block"} (default 5).}

\item{df}{Degrees of freedom for \code{X_dist = "t"} (default 5).}

\item{prob}{Success prob for \code{X_dist = "bernoulli"} (default 0.5).}

\item{active_idx}{Optional integer vector of active feature indices (length s). If NULL, uses 1:s.}

\item{phi}{Precision parameter: scalar, length-n vector, or function \verb{(mu, X) -> length-n}.}

\item{mechanism}{Interval mechanism per row: \code{"jitter"}, \code{"quantile"}, or \code{"mixed"}.}

\item{mix_prob}{Probability of jitter when \code{mechanism = "mixed"}.}

\item{delta}{Symmetric jitter half-width (scalar / vector / function).}

\item{delta_low, delta_high}{Asymmetric jitter widths (override \code{delta} if set).}

\item{alpha}{Miscoverage for quantile intervals (scalar / vector / function).}

\item{alpha_low, alpha_high}{Asymmetric miscoverage (override \code{alpha} if set).}

\item{na_rate}{Fraction of rows with a missing bound (default 0).}

\item{na_side}{Which bound to drop: \code{"left"}, \code{"right"}, or \code{"random"}.}

\item{centerX, scaleX}{Whether to center/scale X before returning.}

\item{seed}{RNG seed.}
}
\value{
list with \verb{X, Y, Y_low, Y_high, mu, beta, a0, phi, info, settings}.
}
\description{
Simulate \strong{interval} Beta-regression data (flexible)
}
