% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSampleSizeArcsine.R
\name{calcSampleSizeArcsine}
\alias{calcSampleSizeArcsine}
\title{Calculate Sample Size Using Arcsine Transformation}
\usage{
calcSampleSizeArcsine(
  S0,
  S1,
  alpha = 0.05,
  power = 0.8,
  accrual = 24,
  followup = 24,
  timePoint = 18,
  steps = 10000
)
}
\arguments{
\item{S0}{Numeric. Survival probability under the null hypothesis (must be strictly between 0 and 1).}

\item{S1}{Numeric. Survival probability under the alternative hypothesis (must be strictly between 0 and 1).}

\item{alpha}{Numeric. The one-sided Type I error rate. Default is 0.05.}

\item{power}{Numeric. Desired statistical power of the test (1 - beta). Default is 0.80.}

\item{accrual}{Numeric. Duration of the accrual period in months. Default is 24.}

\item{followup}{Numeric. Additional follow-up duration in months after accrual. Default is 24.}

\item{timePoint}{Numeric. Time of interest in months for evaluating survival probabilities. Default is 18.}

\item{steps}{Integer. Number of steps for numeric integration if \code{timePoint} exceeds follow-up duration. Default is 10,000.}
}
\value{
Integer. The required sample size, rounded up to the nearest whole number.
}
\description{
This function calculates the required sample size for single-arm survival studies
based on the arcsine transformation method. It accounts for uniform accrual
and exponential survival assumptions, including numeric integration for time
points that exceed the follow-up period.
}
\examples{
# Calculate sample size for typical survival probabilities
calcSampleSizeArcsine(S0 = 0.90, S1 = 0.96)

# Adjusting for lower survival probabilities and extended accrual
calcSampleSizeArcsine(
  S0 = 0.80,
  S1 = 0.85,
  accrual = 36,
  followup = 12,
  timePoint = 24
)

}
