% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalSVG_SPARKX.R
\name{CalSVG_SPARKX}
\alias{CalSVG_SPARKX}
\title{SPARK-X: Non-parametric Kernel-based SVG Detection}
\usage{
CalSVG_SPARKX(
  expr_matrix,
  spatial_coords,
  kernel_option = c("mixture", "single"),
  adjust_method = "BY",
  n_threads = 1L,
  verbose = TRUE
)
}
\arguments{
\item{expr_matrix}{Numeric matrix of gene expression values.
\itemize{
  \item Rows: genes
  \item Columns: spatial locations (spots/cells)
  \item Values: raw counts or normalized counts (NOT log-transformed)
}
Note: SPARK-X works best with count data, not log-transformed data.}

\item{spatial_coords}{Numeric matrix of spatial coordinates.
\itemize{
  \item Rows: spatial locations (must match columns of expr_matrix)
  \item Columns: x, y coordinates
}}

\item{kernel_option}{Character string specifying which kernels to use.
\itemize{
  \item \code{"mixture"} (default): Test with all 11 kernels:
    1 projection + 5 Gaussian + 5 cosine. Most comprehensive but slower.
    Recommended for detecting diverse spatial patterns.
  \item \code{"single"}: Test with projection kernel only. Faster but
    may miss some pattern types.
}}

\item{adjust_method}{Character string for p-value adjustment.
Default is "BY" (Benjamini-Yekutieli), which is more conservative and
appropriate when tests may be correlated.
Other options: "BH", "bonferroni", "holm", "none".}

\item{n_threads}{Integer. Number of parallel threads. Default is 1.
Higher values significantly speed up computation for large datasets.}

\item{verbose}{Logical. Print progress messages. Default is TRUE.}
}
\value{
A data.frame with SVG detection results. Columns:
  \itemize{
    \item \code{gene}: Gene identifier
    \item \code{p.value}: Combined p-value across all kernels (ACAT method)
    \item \code{p.adj}: Multiple testing adjusted p-value
    \item If \code{kernel_option = "mixture"}, additional columns for
      individual kernel statistics and p-values (stat_*, pval_*)
  }
}
\description{
Detect spatially variable genes using SPARK-X, a non-parametric method
that tests for spatial expression patterns using multiple kernels.

SPARK-X is a scalable non-parametric method for identifying spatially
variable genes. It uses variance component score tests with multiple
spatial kernels (projection, Gaussian, and cosine) to detect various
types of spatial expression patterns.
}
\details{
\strong{Method Overview:}

SPARK-X uses a variance component score test framework:
\deqn{T_g = \frac{n \cdot y_g^T K y_g}{\|y_g\|^2}}

where:
\itemize{
  \item y_g = expression vector for gene g
  \item K = spatial kernel matrix (derived from coordinates)
  \item n = number of spatial locations
}

\strong{Kernel Types:}
\itemize{
  \item \code{Projection kernel}: Linear kernel based on scaled coordinates.
    Detects gradients and linear spatial trends.
  \item \code{Gaussian kernels}: Multiple bandwidth Gaussian RBF kernels.
    Detect localized hotspots of different sizes.
  \item \code{Cosine kernels}: Multiple frequency periodic kernels.
    Detect periodic/oscillating spatial patterns.
}

\strong{P-value Computation:}
\itemize{
  \item Individual kernel p-values: Davies' method for quadratic forms
  \item Combined p-value: ACAT (Aggregated Cauchy Association Test)
}

\strong{Advantages:}
\itemize{
  \item Non-parametric: No distributional assumptions
  \item Scalable: O(n) complexity, handles millions of cells
  \item Multiple kernels: Detects diverse pattern types
  \item Robust: ACAT combination handles correlated tests
}

\strong{Computational Considerations:}
\itemize{
  \item \code{mixture} option: ~11x slower than \code{single}
  \item Memory: O(n) per gene, efficient for large datasets
  \item Parallelization provides near-linear speedup
}
}
\examples{
# Load example data
data(example_svg_data)
expr <- example_svg_data$counts[1:20, ]  # Use counts (not log)
coords <- example_svg_data$spatial_coords

# Fast mode with single kernel (no extra dependencies)
results <- CalSVG_SPARKX(expr, coords, 
                         kernel_option = "single",
                         verbose = FALSE)
head(results)

}
\references{
Zhu, J., Sun, S., & Zhou, X. (2021). SPARK-X: non-parametric modeling
enables scalable and robust detection of spatial expression patterns
for large spatial transcriptomic studies. Genome Biology.
}
\seealso{
\code{\link{CalSVG}}, \code{\link{ACAT_combine}}
}
