% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_collapse.R
\name{total_collapse}
\alias{total_collapse}
\title{Collapse variables to single representation}
\usage{
total_collapse(data, variables, total = "Total", include_names = NULL)
}
\arguments{
\item{data}{A data frame containing the variables to be collapsed.}

\item{variables}{A vector of variable names or a named list of variable names.
\itemize{
\item If \code{variables} is a vector, the specified variables in \code{data} are collapsed
into a single character vector.
\item If \code{variables} is a named list, each element in the list defines a group of
variables to consolidate into a new column.
Each list name will be used as the new column name in the resulting data frame.
}}

\item{total}{A total code or vector of total codes to use in the result.
\itemize{
\item If \code{variables} is a vector, \code{total} specifies the code to represent collapsed values.
\item If \code{variables} is a named list, \code{total} may contain one code per group.
}}

\item{include_names}{A character string or \code{NULL} (default).
\itemize{
\item If \code{variables} is a vector, whether the resulting output vector is named depends
on whether \code{include_names} is \code{NULL} or not. The actual value of \code{include_names}
is ignored in this case.
\item If \code{variables} is a named list, \code{include_names} specifies a suffix to append to
each group name, creating one additional column per group.
If \code{NULL}, no additional columns with variable names are included in the result.
}}
}
\value{
A character vector (if \code{variables} is a vector) or a modified data frame (if \code{variables} is a named list).
}
\description{
Simplify a data frame by collapsing specified variables,
according to the location of total codes,
into a single vector or by consolidating groups of variables into new columns.
}
\examples{

# Creates data that can act as input
magnitude1 <- SSBtoolsData("magnitude1")
a <- model_aggregate(magnitude1, 
                     formula = ~geo + eu + sector2 + sector4, 
                     sum_vars = "value", 
                     avoid_hierarchical = TRUE)
a

b <- total_collapse(a, list(GEO = c("geo", "eu"), SECTOR = c("sector2", "sector4")))
b

total_collapse(a, c("geo", "eu"))
total_collapse(a, c("sector2", "sector4"))                                 


# Similar examples with both `total` and `include_names` parameters
aa <- a
aa[1:2][aa[1:2] == "Total"] <- "Europe"
aa[3:4][aa[3:4] == "Total"] <- ""
aa

bb <- total_collapse(data = aa, 
                     variables = list(GEO = c("geo", "eu"), 
                                      SECTOR = c("sector2", "sector4")), 
                     total = c("Europe", ""),
                     include_names = "_Vars")
bb

total_collapse(aa, c("geo", "eu"), total = "Europe", include_names = "_Vars")
total_collapse(aa, c("sector2", "sector4"), total = "", include_names = "_Vars") 


# All four variables can be collapsed
total_collapse(a, 
               list(ALL = c("geo", "eu", "sector2", "sector4")), 
               include_names = "_Vars")

}
