% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVariantLDs.R
\name{findPairwiseLD}
\alias{findPairwiseLD}
\title{Computes and returns LD values between the given variants.}
\usage{
findPairwiseLD(
  rsList,
  file = NULL,
  pairwise = FALSE,
  build = 38,
  db = "1000GENOMES:phase_3:EUR",
  r2 = 0.1
)
}
\arguments{
\item{rsList}{A vector of rs numbers.}

\item{file}{Path to the Excel file for saving search results.}

\item{pairwise}{If TRUE, compute pairwise LD between all elements of a list.
If FALSE, computes the LD between first and other elements of the list. default: FALSE}

\item{build}{Genome build. Either 37 or 38. default: 38}

\item{db}{The population database for calculating LD scores.
This can be found using \code{Ensembl.Databases()} function. default: "1000GENOMES:phase_3:EUR"}

\item{r2}{Only return pairs of variants whose r-squared value is equal to or greater than the value provided. default: 0.1.}
}
\value{
A data table with variant information.
}
\description{
This function returns a data frame of LD values between the given variants in a selected population.
}
