% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basisFunInitAndCompute.R
\name{initialize_basisfun_inducingpt}
\alias{initialize_basisfun_inducingpt}
\title{Initialize parameters for inducing-point basis functions}
\usage{
initialize_basisfun_inducingpt(
  dimension,
  kernel = "Mat52",
  lengthscale,
  pointscoord = NULL,
  numberPoints = NULL
)
}
\arguments{
\item{dimension}{Integer. Input (\eqn{[\mathbf{x},\,t]}{[x, t]}) dimension.}

\item{kernel}{Character. Kernel type ("Exp", "Mat32", "Mat52", "Gaussian").}

\item{lengthscale}{Numeric vector. Lengthscales used for scaling the input space.}

\item{pointscoord}{Optional matrix of inducing point coordinates.
If none is provided, we sample them uniformly in the unit hypercube.}

\item{numberPoints}{Integer. Number of inducing points
(used if \code{pointscoord} is NULL).}
}
\value{
List with kernel square root and inverse root matrices, and scaled coordinates.
}
\description{
Computes kernel matrix and its decompositions for use in inducing-point basis functions.
}
\keyword{internal}
