% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAP_funcs.R
\name{shap.plot.force_plot_bygroup}
\alias{shap.plot.force_plot_bygroup}
\title{Create faceted SHAP force plots by cluster}
\usage{
shap.plot.force_plot_bygroup(shapobs, id = "sorted_id", y_parent_limit = NULL)
}
\arguments{
\item{shapobs}{The dataset obtained by \code{shap.prep.stack.data}.}

\item{id}{the id variable.}

\item{y_parent_limit}{set y-axis limits.}
}
\description{
Creates a faceted display with one force plot per observation cluster,
allowing comparison of prediction patterns across different groups.
}
\examples{
# Example: SHAP force plots (stacked bar charts)
# Shows contribution of each feature to individual predictions

plot_data <- shap.prep.stack.data(shap_contrib = shap_values_iris,
                                  n_groups = 4)
shap.plot.force_plot(plot_data)
shap.plot.force_plot(plot_data, zoom_in_group = 2)

# Plot all clusters separately
shap.plot.force_plot_bygroup(plot_data)
}
