% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_est.R
\name{rc_est.class}
\alias{rc_est.class}
\title{An S4 class to represent the estimation of the Return Curve}
\usage{
rc_est.class(
  data,
  qmarg,
  constrainedshape,
  w,
  p,
  method,
  q,
  qalphas,
  k,
  constrained,
  tol,
  par_init,
  interval,
  rc
)
}
\description{
An S4 class to represent the estimation of the Return Curve
}
\section{Slots}{

\describe{
\item{\code{data}}{A matrix containing the data on the original margins.}

\item{\code{qmarg}}{A vector containing the marginal quantile used to fit the Generalised Pareto Distribution (GPD) for each variable. Default is \code{rep(0.95, 2)}.}

\item{\code{constrainedshape}}{Logical. If \code{TRUE} (Default), the estimated shape parameter of the Generalised Pareto Distribution (GPD) is constrained to strictly above \code{-1}.}

\item{\code{w}}{Sequence of rays between \code{0} and \code{1}. Default is \code{seq(0, 1, by = 0.01)}.}

\item{\code{method}}{String that indicates which method is used for the estimation of the angular dependence function. Must either be \code{"hill"}, to use the Hill estimator \insertCite{Hill1975}{ReturnCurves}, or \code{"cl"} to use the smooth estimator based on Bernstein-Bezier polynomials estimated by composite maximum likelihood.}

\item{\code{p}}{\loadmathjax{} Curve survival probability. Must be \mjeqn{p < 1-q}{p < 1-q} and \mjeqn{p < 1-q_\alpha}{p < 1-qalphas}.}

\item{\code{q}}{Marginal quantile used for the min-projection variable \mjeqn{T^1}{} at angle \mjeqn{\omega}{} \mjeqn{\left(t^1_\omega = t_\omega - u_\omega | t_\omega > u_\omega\right)}{}, and/or Hill estimator \insertCite{Hill1975}{ReturnCurves}. Default is \code{0.95}.}

\item{\code{qalphas}}{A vector containing the marginal quantile used for the Heffernan and Tawn conditional extremes model \insertCite{HeffernanTawn2004}{ReturnCurves} for each variable, if \code{constrained = TRUE}. Default set to \code{rep(0.95, 2)}.}

\item{\code{k}}{Polynomial degree for the Bernstein-Bezier polynomials used for the estimation of the angular dependence function with the composite likelihood method \insertCite{MurphyBarltropetal2024}{ReturnCurves}. Default set to \code{7}.}

\item{\code{constrained}}{Logical. If \code{FALSE} (default) no knowledge of the conditional extremes parameters is incorporated in the angular dependence function estimation.}

\item{\code{tol}}{Convergence tolerance for the composite maximum likelihood procedure. Default set to \code{0.0001}.}

\item{\code{par_init}}{Initial values for the parameters \mjeqn{\beta}{} of the Bernstein-Bezier polynomials used for estimation of the angular dependence function with the composite likelihood method \insertCite{MurphyBarltropetal2024}{ReturnCurves}. Default set to a vector of \code{0} of length \code{k-1}.}

\item{\code{interval}}{Maximum likelihood estimates \mjeqn{\hat{\alpha}^1_{x\mid y}}{} and \mjeqn{\hat{\alpha}^1_{y\mid x}}{} from the conditional extremes model if \code{constrained = TRUE}.}

\item{\code{rc}}{A matrix containing the estimates of the Return Curve.}
}}

\keyword{internal}
