% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dSZMW.R
\name{dSZMW}
\alias{dSZMW}
\alias{pSZMW}
\alias{qSZMW}
\alias{rSZMW}
\alias{hSZMW}
\title{The Sarhan and Zaindin's Modified Weibull distribution}
\usage{
dSZMW(x, mu, sigma, nu, log = FALSE)

pSZMW(q, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

qSZMW(p, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

rSZMW(n, mu, sigma, nu)

hSZMW(x, mu, sigma, nu)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{scale parameter.}

\item{sigma}{shape parameter.}

\item{nu}{shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dSZMW} gives the density, \code{pSZMW} gives the distribution 
function, \code{qSZMW} gives the quantile function, \code{rSZMW}
generates random deviates and \code{hSZMW} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for Sarhan and Zaindins modified weibull distribution
with parameters \code{mu}, \code{sigma} and \code{nu}.
}
\details{
The Sarhan and Zaindins modified weibull with parameters \code{mu}, 
\code{sigma} and \code{nu} has density given by

\eqn{f(x)=(\mu + \sigma \nu x^{\nu - 1}) \exp(- \mu x - \sigma x^\nu)}

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma > 0} and \eqn{\nu > 0}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dSZMW(x, mu = 2, sigma = 1.5, nu = 0.2), from = 0, to = 2, 
      ylim = c(0, 1.7), col = "red", las = 1, ylab = "f(x)")
## The cumulative distribution and the Reliability function
par(mfrow = c(1, 2))
curve(pSZMW(x, mu = 2, sigma = 1.5, nu = 0.2), from = 0, to = 2, ylim = c(0, 1),
      col = "red", las = 1, ylab = "F(x)")
curve(pSZMW(x, mu = 2, sigma = 1.5, nu = 0.2, lower.tail = FALSE), from = 0,
      to = 2, ylim = c(0, 1), col = "red", las = 1, ylab = "R(x)")

## The quantile function
p <- seq(from = 0, to = 0.99999, length.out = 100)
plot(x = qSZMW(p = p, mu = 2, sigma = 1.5, nu = 0.2), y = p, xlab = "Quantile",
     las = 1, ylab = "Probability")
curve(pSZMW(x, mu = 2, sigma = 1.5, nu = 0.2), from = 0, add = TRUE, col = "red")

## The random function
hist(rSZMW(n = 1000, mu = 2, sigma = 1.5, nu = 0.2), freq = FALSE, xlab = "x",
     las = 1, main = "")
curve(dSZMW(x, mu = 2, sigma = 1.5, nu = 0.2),  from = 0, add = TRUE, col = "red")

## The Hazard function
par(mfrow=c(1,1))
curve(hSZMW(x, mu = 2, sigma = 1.5, nu = 0.2), from = 0, to = 3, ylim = c(0, 8),
      col = "red", ylab = "Hazard function", las = 1)

par(old_par) # restore previous graphical parameters
}
\references{
Almalki, S. J., & Nadarajah, S. (2014). Modifications of the 
Weibull distribution: A review. Reliability Engineering & 
System Safety, 124, 32-55.

Sarhan, A. M., & Zaindin, M. (2009). 
Modified Weibull distribution. APPS. Applied Sciences, 11, 123-136.
}
\seealso{
\link{SZMW}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
