% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dGWF.R
\name{dGWF}
\alias{dGWF}
\alias{pGWF}
\alias{qGWF}
\alias{rGWF}
\alias{hGWF}
\title{Generalized Weibull distribution}
\usage{
dGWF(x, mu, sigma, nu, log = FALSE)

pGWF(q, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

qGWF(p, mu, sigma, nu)

rGWF(n, mu, sigma, nu)

hGWF(x, mu, sigma, nu)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter one.}

\item{sigma}{parameter two.}

\item{nu}{parameter three.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dGWF} gives the density, \code{pGWF} gives the distribution
function, \code{qGWF} gives the quantile function, \code{rGWF}
generates random deviates and \code{hGWF} gives the hazard function.
}
\description{
Density, distribution function, quantile function, random generation and
hazard function for the generalized Weibull distribution with parameters
\code{mu}, \code{sigma} and \code{nu}.
}
\details{
The generalized Weibull with parameters \code{mu}, \code{sigma} and
\code{nu} has density given by

\deqn{f(x) = \mu \sigma x^{\sigma - 1}
   \left( 1 - \mu \nu x^\sigma \right)^{\frac{1}{\nu} - 1}}

for \eqn{x > 0}, \eqn{\mu>0}, \eqn{\sigma>0} and \eqn{-\infty<\nu<\infty}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(
    dGWF(x, mu = 5, sigma = 2, nu = -0.2),
    from = 0, to = 5, col = "red", las = 1, ylab = "f(x)"
)

## The cumulative distribution and the Reliability function
par(mfrow = c(1, 2))
curve(
    pGWF(x, mu = 5, sigma = 2, nu = -0.2),
    from = 0, to = 5, ylim = c(0, 1),
    col = "red", las = 1, ylab = "F(x)"
)
curve(
    pGWF(
        x, mu = 5, sigma = 2, nu = -0.2, 
        lower.tail = FALSE
    ),
    from = 0, to = 5, ylim = c(0, 1),
    col = "red", las = 1, ylab = "R(x)"
)

## The quantile function
p <- seq(from = 0, to = 0.999, length.out = 100)
plot(
    x = qGWF(p, mu = 5, sigma = 2, nu = -0.2),
    y = p, xlab = "Quantile", las = 1,
    ylab = "Probability"
)
curve(
    pGWF(x, mu = 5, sigma = 2, nu = -0.2),
    from = 0, add = TRUE, col = "red"
)

## The random function
hist(
    rGWF(n = 10000, mu = 5, sigma = 2, nu = -0.2),
    freq = FALSE, xlab = "x", las = 1, main = "", ylim = c(0, 2.0)
)
curve(dGWF(x, mu = 5, sigma = 2, nu = -0.2),
    from = 0, add = TRUE, col = "red"
)

## The Hazard function
par(mfrow = c(1, 1))
curve(
    hGWF(x, mu = 0.003, sigma = 5e-6, nu = 0.025),
    from = 0, to = 250, col = "red", 
    ylab = "Hazard function", las = 1
)

par(old_par) # restore previous graphical parameters
}
\references{
Mudholkar, G. S., & Kollia, G. D. (1994). Generalized Weibull family: 
a structural analysis. Communications in statistics-theory and methods, 
23(4), 1149-1171.
}
\author{
Jaime Mosquera, \email{jmosquerag@unal.edu.co}
}
